/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.FilteredConnectPoint;
import org.onosproject.net.NetworkResource;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.ConnectivityIntent;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class MultiPointToSinglePointIntent
extends ConnectivityIntent {
    private final Set<FilteredConnectPoint> ingressPoints;
    private final FilteredConnectPoint egressPoint;

    private MultiPointToSinglePointIntent(ApplicationId appId, Key key, TrafficSelector selector, TrafficTreatment treatment, Set<FilteredConnectPoint> ingressPoints, FilteredConnectPoint egressPoint, List<Constraint> constraints, int priority) {
        super(appId, key, (Collection<NetworkResource>)ImmutableSet.of(), selector, treatment, constraints, priority);
        Preconditions.checkNotNull(ingressPoints);
        Preconditions.checkArgument((!ingressPoints.isEmpty() ? 1 : 0) != 0, (Object)"Ingress point set cannot be empty");
        Preconditions.checkNotNull((Object)egressPoint);
        Preconditions.checkArgument((!ingressPoints.contains(egressPoint) ? 1 : 0) != 0, (String)"Set of ingresses should not contain egress (egress: %s)", (Object[])new Object[]{egressPoint});
        this.ingressPoints = ImmutableSet.copyOf(ingressPoints);
        this.egressPoint = egressPoint;
    }

    protected MultiPointToSinglePointIntent() {
        this.ingressPoints = null;
        this.egressPoint = null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(MultiPointToSinglePointIntent intent) {
        return new Builder(intent);
    }

    public Set<ConnectPoint> ingressPoints() {
        return this.ingressPoints.stream().map(FilteredConnectPoint::connectPoint).collect(Collectors.toSet());
    }

    public ConnectPoint egressPoint() {
        return this.egressPoint.connectPoint();
    }

    public Set<FilteredConnectPoint> filteredIngressPoints() {
        return this.ingressPoints;
    }

    public FilteredConnectPoint filteredEgressPoint() {
        return this.egressPoint;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("id", (Object)this.id()).add("key", (Object)this.key()).add("appId", (Object)this.appId()).add("priority", this.priority()).add("resources", this.resources()).add("selector", (Object)this.selector()).add("treatment", (Object)this.treatment()).add("ingress", this.ingressPoints()).add("egress", (Object)this.egressPoint()).add("filteredIngressCPs", this.filteredIngressPoints()).add("filteredEgressCP", (Object)this.filteredEgressPoint()).add("constraints", this.constraints()).toString();
    }

    public static final class Builder
    extends ConnectivityIntent.Builder {
        private final Logger log = LoggerFactory.getLogger(this.getClass());
        private Set<FilteredConnectPoint> ingressPoints;
        private FilteredConnectPoint egressPoint;

        private Builder() {
        }

        protected Builder(MultiPointToSinglePointIntent intent) {
            super(intent);
            this.filteredIngressPoints(intent.filteredIngressPoints()).filteredEgressPoint(intent.filteredEgressPoint());
        }

        @Override
        public Builder appId(ApplicationId appId) {
            return (Builder)super.appId(appId);
        }

        @Override
        public Builder key(Key key) {
            return (Builder)super.key(key);
        }

        @Override
        public Builder selector(TrafficSelector selector) {
            return (Builder)super.selector(selector);
        }

        @Override
        public Builder treatment(TrafficTreatment treatment) {
            return (Builder)super.treatment(treatment);
        }

        @Override
        public Builder constraints(List<Constraint> constraints) {
            return (Builder)super.constraints(constraints);
        }

        @Override
        public Builder priority(int priority) {
            return (Builder)super.priority(priority);
        }

        @Deprecated
        public Builder ingressPoints(Set<ConnectPoint> ingressPoints) {
            if (this.ingressPoints != null) {
                this.log.warn("Ingress points are already set, this will override original ingress points.");
            }
            this.ingressPoints = ingressPoints.stream().map(FilteredConnectPoint::new).collect(Collectors.toSet());
            return this;
        }

        @Deprecated
        public Builder egressPoint(ConnectPoint egressPoint) {
            if (this.egressPoint != null) {
                this.log.warn("Egress point is already set, this will override original egress point.");
            }
            this.egressPoint = new FilteredConnectPoint(egressPoint);
            return this;
        }

        public Builder filteredIngressPoints(Set<FilteredConnectPoint> ingressPoints) {
            this.ingressPoints = ImmutableSet.copyOf(ingressPoints);
            return this;
        }

        public Builder filteredEgressPoint(FilteredConnectPoint egressPoint) {
            this.egressPoint = egressPoint;
            return this;
        }

        public MultiPointToSinglePointIntent build() {
            return new MultiPointToSinglePointIntent(this.appId, this.key, this.selector, this.treatment, this.ingressPoints, this.egressPoint, this.constraints, this.priority);
        }
    }
}

