/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow;

import com.google.common.testing.EqualsTester;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onosproject.core.DefaultGroupId;
import org.onosproject.core.GroupId;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleExtPayLoad;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.IntentTestsMocks;

public class DefaultFlowRuleTest {
    private static final IntentTestsMocks.MockSelector SELECTOR = new IntentTestsMocks.MockSelector();
    private static final IntentTestsMocks.MockTreatment TREATMENT = new IntentTestsMocks.MockTreatment();
    private static byte[] b = new byte[3];
    private static FlowRuleExtPayLoad payLoad = FlowRuleExtPayLoad.flowRuleExtPayLoad((byte[])b);
    final FlowRule flowRule1 = new IntentTestsMocks.MockFlowRule(1, payLoad);
    final FlowRule sameAsFlowRule1 = new IntentTestsMocks.MockFlowRule(1, payLoad);
    final DefaultFlowRule defaultFlowRule1 = new DefaultFlowRule(this.flowRule1);
    final DefaultFlowRule sameAsDefaultFlowRule1 = new DefaultFlowRule(this.sameAsFlowRule1);

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutableBaseClass(DefaultFlowRule.class);
    }

    @Test
    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.defaultFlowRule1, this.sameAsDefaultFlowRule1}).testEquals();
    }

    @Test
    public void testCreationFromFlowRule() {
        MatcherAssert.assertThat((Object)this.defaultFlowRule1.deviceId(), (Matcher)Matchers.is((Object)this.flowRule1.deviceId()));
        MatcherAssert.assertThat((Object)this.defaultFlowRule1.appId(), (Matcher)Matchers.is((Object)this.flowRule1.appId()));
        MatcherAssert.assertThat((Object)this.defaultFlowRule1.id(), (Matcher)Matchers.is((Object)this.flowRule1.id()));
        MatcherAssert.assertThat((Object)this.defaultFlowRule1.isPermanent(), (Matcher)Matchers.is((Object)this.flowRule1.isPermanent()));
        MatcherAssert.assertThat((Object)this.defaultFlowRule1.priority(), (Matcher)Matchers.is((Object)this.flowRule1.priority()));
        MatcherAssert.assertThat((Object)this.defaultFlowRule1.selector(), (Matcher)Matchers.is((Object)this.flowRule1.selector()));
        MatcherAssert.assertThat((Object)this.defaultFlowRule1.treatment(), (Matcher)Matchers.is((Object)this.flowRule1.treatment()));
        MatcherAssert.assertThat((Object)this.defaultFlowRule1.timeout(), (Matcher)Matchers.is((Object)this.flowRule1.timeout()));
        MatcherAssert.assertThat((Object)this.defaultFlowRule1.payLoad(), (Matcher)Matchers.is((Object)this.flowRule1.payLoad()));
    }

    @Test
    public void testCreationWithFlowId() {
        FlowRule rule = DefaultFlowRule.builder().forDevice(NetTestTools.did("1")).withSelector((TrafficSelector)SELECTOR).withTreatment((TrafficTreatment)TREATMENT).withPriority(22).makeTemporary(44).fromApp(NetTestTools.APP_ID).build();
        MatcherAssert.assertThat((Object)rule.deviceId(), (Matcher)Matchers.is((Object)NetTestTools.did("1")));
        MatcherAssert.assertThat((Object)rule.isPermanent(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)rule.priority(), (Matcher)Matchers.is((Object)22));
        MatcherAssert.assertThat((Object)rule.selector(), (Matcher)Matchers.is((Object)SELECTOR));
        MatcherAssert.assertThat((Object)rule.treatment(), (Matcher)Matchers.is((Object)TREATMENT));
        MatcherAssert.assertThat((Object)rule.timeout(), (Matcher)Matchers.is((Object)44));
    }

    @Test
    public void testCreationWithPayLoadByFlowTable() {
        DefaultFlowRule rule = new DefaultFlowRule(NetTestTools.did("1"), null, null, 22, NetTestTools.APP_ID, 44, false, payLoad);
        MatcherAssert.assertThat((Object)rule.deviceId(), (Matcher)Matchers.is((Object)NetTestTools.did("1")));
        MatcherAssert.assertThat((Object)rule.isPermanent(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)rule.priority(), (Matcher)Matchers.is((Object)22));
        MatcherAssert.assertThat((Object)rule.timeout(), (Matcher)Matchers.is((Object)44));
        MatcherAssert.assertThat((Object)this.defaultFlowRule1.payLoad(), (Matcher)Matchers.is((Object)payLoad));
    }

    @Test
    public void testCreationWithPayLoadByGroupTable() {
        DefaultFlowRule rule = new DefaultFlowRule(NetTestTools.did("1"), null, null, 22, NetTestTools.APP_ID, (GroupId)new DefaultGroupId(0), 44, false, payLoad);
        MatcherAssert.assertThat((Object)rule.deviceId(), (Matcher)Matchers.is((Object)NetTestTools.did("1")));
        MatcherAssert.assertThat((Object)rule.isPermanent(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)rule.priority(), (Matcher)Matchers.is((Object)22));
        MatcherAssert.assertThat((Object)rule.timeout(), (Matcher)Matchers.is((Object)44));
        MatcherAssert.assertThat((Object)rule.groupId(), (Matcher)Matchers.is((Object)new DefaultGroupId(0)));
        MatcherAssert.assertThat((Object)this.defaultFlowRule1.payLoad(), (Matcher)Matchers.is((Object)payLoad));
    }

    @Test
    public void testCreationWithAppId() {
        FlowRule rule = DefaultFlowRule.builder().forDevice(NetTestTools.did("1")).withSelector((TrafficSelector)SELECTOR).withTreatment((TrafficTreatment)TREATMENT).withPriority(22).fromApp(NetTestTools.APP_ID).makeTemporary(44).build();
        MatcherAssert.assertThat((Object)rule.deviceId(), (Matcher)Matchers.is((Object)NetTestTools.did("1")));
        MatcherAssert.assertThat((Object)rule.isPermanent(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)rule.priority(), (Matcher)Matchers.is((Object)22));
        MatcherAssert.assertThat((Object)rule.selector(), (Matcher)Matchers.is((Object)SELECTOR));
        MatcherAssert.assertThat((Object)rule.treatment(), (Matcher)Matchers.is((Object)TREATMENT));
        MatcherAssert.assertThat((Object)rule.timeout(), (Matcher)Matchers.is((Object)44));
    }

    @Test
    public void testCreationWithConsistentFlowId() {
        FlowRule rule1 = DefaultFlowRule.builder().forDevice(NetTestTools.did("1")).withSelector((TrafficSelector)SELECTOR).withTreatment((TrafficTreatment)TREATMENT).withPriority(22).forTable(1).fromApp(NetTestTools.APP_ID).makeTemporary(44).build();
        FlowRule rule2 = DefaultFlowRule.builder().forDevice(NetTestTools.did("1")).withSelector((TrafficSelector)SELECTOR).withTreatment((TrafficTreatment)TREATMENT).withPriority(22).forTable(1).fromApp(NetTestTools.APP_ID).makeTemporary(44).build();
        new EqualsTester().addEqualityGroup(new Object[]{rule1.id(), rule2.id()}).testEquals();
    }
}

