/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.group;

import com.google.common.collect.ImmutableList;
import com.google.common.testing.EqualsTester;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.onosproject.core.DefaultGroupId;
import org.onosproject.core.GroupId;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.group.DefaultGroup;
import org.onosproject.net.group.DefaultGroupBucket;
import org.onosproject.net.group.DefaultGroupDescription;
import org.onosproject.net.group.Group;
import org.onosproject.net.group.GroupBucket;
import org.onosproject.net.group.GroupBuckets;
import org.onosproject.net.group.GroupDescription;

public class DefaultGroupTest {
    private final GroupId id1 = new DefaultGroupId(6);
    private final GroupId id2 = new DefaultGroupId(7);
    private final GroupId id3 = new DefaultGroupId(1234);
    private final GroupBucket bucket = DefaultGroupBucket.createSelectGroupBucket((TrafficTreatment)DefaultTrafficTreatment.emptyTreatment());
    private final GroupBuckets groupBuckets = new GroupBuckets((List)ImmutableList.of((Object)this.bucket));
    private final GroupDescription groupDesc1 = new DefaultGroupDescription(NetTestTools.did("1"), GroupDescription.Type.FAILOVER, this.groupBuckets);
    private final GroupDescription groupDesc2 = new DefaultGroupDescription(NetTestTools.did("2"), GroupDescription.Type.FAILOVER, this.groupBuckets);
    private final GroupDescription groupDesc3 = new DefaultGroupDescription(NetTestTools.did("3"), GroupDescription.Type.INDIRECT, this.groupBuckets);
    DefaultGroup group1 = new DefaultGroup(this.id1, this.groupDesc1);
    DefaultGroup sameAsGroup1 = new DefaultGroup(this.id1, this.groupDesc1);
    DefaultGroup group2 = new DefaultGroup(this.id1, this.groupDesc2);
    DefaultGroup group3 = new DefaultGroup(this.id2, this.groupDesc2);
    DefaultGroup group4 = new DefaultGroup(this.id3, this.groupDesc3);

    @Test
    public void checkEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.group1, this.sameAsGroup1}).addEqualityGroup(new Object[]{this.group2}).addEqualityGroup(new Object[]{this.group3}).addEqualityGroup(new Object[]{this.group4}).testEquals();
    }

    @Test
    public void checkConstruction() {
        Assert.assertThat((Object)this.group1.id(), (Matcher)Matchers.is((Object)this.id1));
        Assert.assertThat((Object)this.group1.bytes(), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)this.group1.life(), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)this.group1.packets(), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)this.group1.referenceCount(), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)this.group1.buckets(), (Matcher)Matchers.is((Object)this.groupBuckets));
        Assert.assertThat((Object)this.group1.state(), (Matcher)Matchers.is((Object)Group.GroupState.PENDING_ADD));
    }

    @Test
    public void checkConstructionWithDid() {
        DefaultGroup group = new DefaultGroup(this.id2, NetTestTools.did("1"), GroupDescription.Type.ALL, this.groupBuckets);
        Assert.assertThat((Object)group.id(), (Matcher)Matchers.is((Object)this.id2));
        Assert.assertThat((Object)group.bytes(), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)group.life(), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)group.packets(), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)group.referenceCount(), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)group.deviceId(), (Matcher)Matchers.is((Object)NetTestTools.did("1")));
        Assert.assertThat((Object)group.buckets(), (Matcher)Matchers.is((Object)this.groupBuckets));
    }
}

