/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.group;

import com.google.common.testing.EqualsTester;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.onosproject.core.DefaultGroupId;
import org.onosproject.core.GroupId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.group.DefaultGroupBucket;
import org.onosproject.net.group.GroupBucket;
import org.onosproject.net.group.GroupDescription;

public class GroupBucketTest {
    private final GroupId groupId = new DefaultGroupId(7);
    private final GroupId nullGroup = null;
    private final PortNumber nullPort = null;
    private final TrafficTreatment treatment = DefaultTrafficTreatment.emptyTreatment();
    private final GroupBucket selectGroupBucket = DefaultGroupBucket.createSelectGroupBucket((TrafficTreatment)this.treatment);
    private final GroupBucket sameAsSelectGroupBucket = DefaultGroupBucket.createSelectGroupBucket((TrafficTreatment)this.treatment);
    private final GroupBucket failoverGroupBucket = DefaultGroupBucket.createFailoverGroupBucket((TrafficTreatment)this.treatment, (PortNumber)PortNumber.IN_PORT, (GroupId)this.groupId);
    private final GroupBucket indirectGroupBucket = DefaultGroupBucket.createIndirectGroupBucket((TrafficTreatment)this.treatment);
    private final GroupBucket selectGroupBucketWithWeight = DefaultGroupBucket.createSelectGroupBucket((TrafficTreatment)this.treatment, (short)5);

    @Test
    public void checkEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.selectGroupBucket, this.sameAsSelectGroupBucket, this.selectGroupBucketWithWeight}).addEqualityGroup(new Object[]{this.failoverGroupBucket}).addEqualityGroup(new Object[]{this.indirectGroupBucket}).testEquals();
    }

    private void checkValues(GroupBucket bucket, GroupDescription.Type type, long bytes, long packets, short weight, GroupId groupId, PortNumber portNumber) {
        MatcherAssert.assertThat((Object)bucket.type(), (Matcher)CoreMatchers.is((Object)type));
        MatcherAssert.assertThat((Object)bucket.bytes(), (Matcher)CoreMatchers.is((Object)bytes));
        MatcherAssert.assertThat((Object)bucket.packets(), (Matcher)CoreMatchers.is((Object)packets));
        MatcherAssert.assertThat((Object)bucket.treatment(), (Matcher)CoreMatchers.is((Object)this.treatment));
        MatcherAssert.assertThat((Object)bucket.weight(), (Matcher)CoreMatchers.is((Object)weight));
        MatcherAssert.assertThat((Object)bucket.watchGroup(), (Matcher)CoreMatchers.is((Object)groupId));
        MatcherAssert.assertThat((Object)bucket.watchPort(), (Matcher)CoreMatchers.is((Object)portNumber));
    }

    @Test
    public void checkSelectGroup() {
        ((DefaultGroupBucket)this.selectGroupBucket).setBytes(4L);
        ((DefaultGroupBucket)this.selectGroupBucket).setPackets(44L);
        this.checkValues(this.selectGroupBucket, GroupDescription.Type.SELECT, 4L, 44L, (short)1, this.nullGroup, this.nullPort);
    }

    @Test
    public void checkSelectGroupWithPriority() {
        this.checkValues(this.selectGroupBucketWithWeight, GroupDescription.Type.SELECT, 0L, 0L, (short)5, this.nullGroup, this.nullPort);
    }

    @Test
    public void checkFailoverGroup() {
        this.checkValues(this.failoverGroupBucket, GroupDescription.Type.FAILOVER, 0L, 0L, (short)-1, this.groupId, PortNumber.IN_PORT);
    }

    @Test
    public void checkIndirectGroup() {
        this.checkValues(this.indirectGroupBucket, GroupDescription.Type.INDIRECT, 0L, 0L, (short)-1, this.nullGroup, this.nullPort);
    }

    @Test
    public void checkZeroWeight() {
        GroupBucket bucket = DefaultGroupBucket.createSelectGroupBucket((TrafficTreatment)this.treatment, (short)0);
        MatcherAssert.assertThat((Object)bucket, (Matcher)CoreMatchers.nullValue());
    }
}

