/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.model.topo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.PortNumber;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.net.region.RegionId;
import org.onosproject.ui.AbstractUiTest;
import org.onosproject.ui.model.topo.UiDeviceLink;
import org.onosproject.ui.model.topo.UiLink;
import org.onosproject.ui.model.topo.UiLinkId;
import org.onosproject.ui.model.topo.UiRegion;
import org.onosproject.ui.model.topo.UiSynthLink;
import org.onosproject.ui.model.topo.UiTopology;

public class UiTopologyTest
extends AbstractUiTest {
    private static final DeviceId DEV_X = DeviceId.deviceId((String)"dev-X");
    private static final DeviceId DEV_Y = DeviceId.deviceId((String)"dev-Y");
    private static final PortNumber P1 = PortNumber.portNumber((long)1L);
    private static final PortNumber P2 = PortNumber.portNumber((long)2L);
    private static final String DEV_X_ID = "dev-x/1";
    private static final String DEV_Y_ID = "dev-y/2";
    private static final ConnectPoint CP_X1 = new ConnectPoint((ElementId)DEV_X, P1);
    private static final ConnectPoint CP_Y2 = new ConnectPoint((ElementId)DEV_Y, P2);
    private static final Link LINK_X1_TO_Y2 = DefaultLink.builder().providerId(ProviderId.NONE).src(CP_X1).dst(CP_Y2).type(Link.Type.DIRECT).build();
    private static final UiLinkId DX1_DY2 = UiLinkId.uiLinkId((Link)LINK_X1_TO_Y2);
    private static final RegionId ROOT = UiRegion.NULL_ID;
    private static final RegionId R1 = RegionId.regionId((String)"R1");
    private static final RegionId R2 = RegionId.regionId((String)"R2");
    private static final RegionId R3 = RegionId.regionId((String)"R3");
    private static final String DEV_LINK_CLASS = "UiDeviceLink";
    private static final String REG_LINK_CLASS = "UiRegionLink";
    private static final String REG_DEV_LINK_CLASS = "UiRegionDeviceLink";
    private UiTopology topo;
    private UiDeviceLink devLink;
    private List<RegionId> xBranch;
    private List<RegionId> yBranch;
    private UiSynthLink synth;

    @Before
    public void setUp() {
        this.topo = new UiTopology();
        this.devLink = new UiDeviceLink(null, DX1_DY2);
        this.devLink.attachBackingLink(LINK_X1_TO_Y2);
    }

    @Test
    public void basic() {
        UiTopologyTest.title("basic");
        UiTopologyTest.print(this.topo);
    }

    private List<RegionId> branch(RegionId ... ids) {
        ArrayList<RegionId> result = new ArrayList<RegionId>(ids.length);
        Collections.addAll(result, ids);
        return result;
    }

    private void verifySynth(RegionId id, String cls, String epA, String epB) {
        this.synth = this.topo.makeSynthLink(this.devLink, this.xBranch, this.yBranch);
        UiLink ulink = this.synth.link();
        UiTopologyTest.print(this.synth);
        UiTopologyTest.print("EpA{%s}  EpB{%s}", ulink.endPointA(), ulink.endPointB());
        Assert.assertEquals((String)"wrong region", (Object)id, (Object)this.synth.regionId());
        Assert.assertEquals((String)"wrong link class", (Object)cls, (Object)ulink.type());
        Assert.assertEquals((String)"wrong EP A", (Object)epA, (Object)ulink.endPointA());
        Assert.assertEquals((String)"wrong EP B", (Object)epB, (Object)ulink.endPointB());
    }

    @Test
    public void makeSynthDevToDevRoot() {
        UiTopologyTest.title("makeSynthDevToDevRoot");
        this.xBranch = this.branch(ROOT);
        this.yBranch = this.branch(ROOT);
        this.verifySynth(ROOT, DEV_LINK_CLASS, DEV_X_ID, DEV_Y_ID);
    }

    @Test
    public void makeSynthDevToDevR1() {
        UiTopologyTest.title("makeSynthDevToDevR1");
        this.xBranch = this.branch(ROOT, R1);
        this.yBranch = this.branch(ROOT, R1);
        this.verifySynth(R1, DEV_LINK_CLASS, DEV_X_ID, DEV_Y_ID);
    }

    @Test
    public void makeSynthDevToDevR2() {
        UiTopologyTest.title("makeSynthDevToDevR2");
        this.xBranch = this.branch(ROOT, R1, R2);
        this.yBranch = this.branch(ROOT, R1, R2);
        this.verifySynth(R2, DEV_LINK_CLASS, DEV_X_ID, DEV_Y_ID);
    }

    @Test
    public void makeSynthRegToRegRoot() {
        UiTopologyTest.title("makeSynthRegToRegRoot");
        this.xBranch = this.branch(ROOT, R1);
        this.yBranch = this.branch(ROOT, R2);
        this.verifySynth(ROOT, REG_LINK_CLASS, (String)R1.id(), (String)R2.id());
    }

    @Test
    public void makeSynthRegToRegR1() {
        UiTopologyTest.title("makeSynthRegToRegR1");
        this.xBranch = this.branch(ROOT, R1, R2);
        this.yBranch = this.branch(ROOT, R1, R3);
        this.verifySynth(R1, REG_LINK_CLASS, (String)R2.id(), (String)R3.id());
    }

    @Test
    public void makeSynthRegToDevRoot() {
        UiTopologyTest.title("makeSynthRegToDevRoot");
        this.xBranch = this.branch(ROOT);
        this.yBranch = this.branch(ROOT, R1);
        this.verifySynth(ROOT, REG_DEV_LINK_CLASS, (String)R1.id(), DEV_X_ID);
        this.xBranch = this.branch(ROOT, R1);
        this.yBranch = this.branch(ROOT);
        this.verifySynth(ROOT, REG_DEV_LINK_CLASS, (String)R1.id(), DEV_Y_ID);
    }

    @Test
    public void makeSynthRegToDevR3() {
        UiTopologyTest.title("makeSynthRegToDevR3");
        this.xBranch = this.branch(ROOT, R3);
        this.yBranch = this.branch(ROOT, R3, R1);
        this.verifySynth(R3, REG_DEV_LINK_CLASS, (String)R1.id(), DEV_X_ID);
        this.xBranch = this.branch(ROOT, R3, R1);
        this.yBranch = this.branch(ROOT, R3);
        this.verifySynth(R3, REG_DEV_LINK_CLASS, (String)R1.id(), DEV_Y_ID);
    }
}

