/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour.protection;

import com.google.common.annotations.Beta;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.behaviour.protection.ProtectedTransportEndpointDescription;
import org.onosproject.net.behaviour.protection.ProtectedTransportEndpointState;
import org.onosproject.net.driver.HandlerBehaviour;

@Beta
public interface ProtectionConfigBehaviour
extends HandlerBehaviour {
    public static final String FINGERPRINT = "protection:fingerprint";

    public CompletableFuture<ConnectPoint> createProtectionEndpoint(ProtectedTransportEndpointDescription var1);

    public CompletableFuture<ConnectPoint> updateProtectionEndpoint(ConnectPoint var1, ProtectedTransportEndpointDescription var2);

    public CompletableFuture<Boolean> deleteProtectionEndpoint(ConnectPoint var1);

    public CompletableFuture<Map<ConnectPoint, ProtectedTransportEndpointDescription>> getProtectionEndpointConfigs();

    default public CompletableFuture<ProtectedTransportEndpointDescription> getProtectionEndpointConfig(ConnectPoint identifier) {
        return this.getProtectionEndpointConfigs().thenApply(m -> (ProtectedTransportEndpointDescription)m.get(identifier));
    }

    public CompletableFuture<Map<ConnectPoint, ProtectedTransportEndpointState>> getProtectionEndpointStates();

    default public CompletableFuture<ProtectedTransportEndpointState> getProtectionEndpointState(ConnectPoint identifier) {
        return this.getProtectionEndpointStates().thenApply(m -> (ProtectedTransportEndpointState)m.get(identifier));
    }

    default public CompletableFuture<Map.Entry<ConnectPoint, ProtectedTransportEndpointState>> getProtectionEndpoint(String fingerprint) {
        return ((CompletableFuture)((CompletableFuture)this.getProtectionEndpointStates().thenApply(Map::entrySet)).thenApply(Collection::stream)).thenApply(s -> s.filter(e -> fingerprint.equals(((ProtectedTransportEndpointState)e.getValue()).description().fingerprint())).findFirst().orElse(null));
    }

    public CompletableFuture<Void> switchWorkingPath(ConnectPoint var1, int var2);
}

