/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.util.function.Function;
import org.joda.time.DateTime;
import org.onlab.util.ByteArraySizeHashPrinter;

public class Versioned<V> {
    private final V value;
    private final long version;
    private final long creationTime;

    public Versioned(V value, long version, long creationTime) {
        this.value = value;
        this.version = version;
        this.creationTime = creationTime;
    }

    public Versioned(V value, long version) {
        this(value, version, System.currentTimeMillis());
    }

    public V value() {
        return this.value;
    }

    public long version() {
        return this.version;
    }

    public long creationTime() {
        return this.creationTime;
    }

    public synchronized <U> Versioned<U> map(Function<V, U> transformer) {
        return new Versioned<U>(transformer.apply(this.value), this.version, this.creationTime);
    }

    public static <U> U valueOrElse(Versioned<U> versioned, U defaultValue) {
        return versioned == null ? defaultValue : versioned.value();
    }

    public static <U> U valueOrNull(Versioned<U> versioned) {
        return Versioned.valueOrElse(versioned, null);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.value, this.version, this.creationTime});
    }

    public boolean equals(Object other) {
        if (!(other instanceof Versioned)) {
            return false;
        }
        Versioned that = (Versioned)other;
        return Objects.equal(this.value, that.value) && Objects.equal((Object)this.version, (Object)that.version) && Objects.equal((Object)this.creationTime, (Object)that.creationTime);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", this.value instanceof byte[] ? new ByteArraySizeHashPrinter((byte[])this.value) : this.value).add("version", this.version).add("creationTime", (Object)new DateTime(this.creationTime)).toString();
    }
}

