/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.onosproject.store.primitives.DefaultDistributedSet;
import org.onosproject.store.service.AsyncDistributedSet;
import org.onosproject.store.service.DistributedSet;
import org.onosproject.store.service.DistributedSetAdapter;
import org.onosproject.store.service.DistributedSetBuilder;
import org.onosproject.store.service.SetEvent;
import org.onosproject.store.service.SetEventListener;

public final class TestDistributedSet<E>
extends DistributedSetAdapter<E> {
    private final List<SetEventListener<E>> listeners;
    private final Set<E> set = new HashSet();
    private final String setName;

    public TestDistributedSet(String setName) {
        this.listeners = new LinkedList<SetEventListener<E>>();
        this.setName = setName;
    }

    private void notifyListeners(SetEvent<E> event) {
        this.listeners.forEach(listener -> listener.event(event));
    }

    @Override
    public CompletableFuture<Void> addListener(SetEventListener<E> listener) {
        this.listeners.add(listener);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> removeListener(SetEventListener<E> listener) {
        this.listeners.remove(listener);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Boolean> add(E element) {
        SetEvent event = new SetEvent(this.setName, SetEvent.Type.ADD, element);
        this.notifyListeners(event);
        return CompletableFuture.completedFuture(this.set.add(element));
    }

    @Override
    public CompletableFuture<Boolean> remove(E element) {
        SetEvent event = new SetEvent(this.setName, SetEvent.Type.REMOVE, element);
        this.notifyListeners(event);
        return CompletableFuture.completedFuture(this.set.remove(element));
    }

    @Override
    public CompletableFuture<Integer> size() {
        return CompletableFuture.completedFuture(this.set.size());
    }

    @Override
    public CompletableFuture<Boolean> isEmpty() {
        return CompletableFuture.completedFuture(this.set.isEmpty());
    }

    @Override
    public CompletableFuture<Void> clear() {
        this.removeAll((Collection<? extends E>)ImmutableSet.copyOf(this.set));
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Boolean> contains(E element) {
        return CompletableFuture.completedFuture(this.set.contains(element));
    }

    @Override
    public CompletableFuture<Boolean> addAll(Collection<? extends E> c) {
        c.forEach(this::add);
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public CompletableFuture<Boolean> containsAll(Collection<? extends E> c) {
        return CompletableFuture.completedFuture(this.set.containsAll(c));
    }

    @Override
    public CompletableFuture<Boolean> retainAll(Collection<? extends E> c) {
        Sets.SetView notInSet2 = Sets.difference(this.set, (Set)((Set)c));
        return this.removeAll((Collection<? extends E>)ImmutableSet.copyOf((Collection)notInSet2));
    }

    @Override
    public CompletableFuture<Boolean> removeAll(Collection<? extends E> c) {
        c.forEach(this::remove);
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public CompletableFuture<? extends Set<E>> getAsImmutableSet() {
        return CompletableFuture.completedFuture(ImmutableSet.copyOf(this.set));
    }

    @Override
    public String name() {
        return this.setName;
    }

    public DistributedSet<E> asDistributedSet() {
        return new DefaultDistributedSet((AsyncDistributedSet)this, 0L);
    }

    public DistributedSet<E> asDistributedSet(long timeoutMillis) {
        return new DefaultDistributedSet((AsyncDistributedSet)this, timeoutMillis);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder<E>
    extends DistributedSetBuilder<E> {
        public AsyncDistributedSet<E> build() {
            return new TestDistributedSet(this.name());
        }
    }
}

