/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.mastership;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.onlab.util.Tools;
import org.onosproject.cluster.NodeId;
import org.onosproject.cluster.RoleInfo;
import org.onosproject.event.ListenerService;
import org.onosproject.mastership.MastershipEvent;
import org.onosproject.mastership.MastershipListener;
import org.onosproject.net.DeviceId;
import org.onosproject.net.MastershipRole;

public interface MastershipService
extends ListenerService<MastershipEvent, MastershipListener> {
    public static final long TIMEOUT_MILLIS = 3000L;

    public MastershipRole getLocalRole(DeviceId var1);

    default public boolean isLocalMaster(DeviceId deviceId) {
        return this.getLocalRole(deviceId) == MastershipRole.MASTER;
    }

    public CompletableFuture<MastershipRole> requestRoleFor(DeviceId var1);

    default public MastershipRole requestRoleForSync(DeviceId deviceId) {
        return (MastershipRole)((Object)Tools.futureGetOrElse(this.requestRoleFor(deviceId), (long)3000L, (TimeUnit)TimeUnit.MILLISECONDS, (Object)((Object)MastershipRole.NONE)));
    }

    public CompletableFuture<Void> relinquishMastership(DeviceId var1);

    default public void relinquishMastershipSync(DeviceId deviceId) {
        Tools.futureGetOrElse(this.relinquishMastership(deviceId), (long)3000L, (TimeUnit)TimeUnit.MILLISECONDS, null);
    }

    public NodeId getMasterFor(DeviceId var1);

    public RoleInfo getNodesFor(DeviceId var1);

    @Deprecated
    public Set<DeviceId> getDevicesOf(NodeId var1);
}

