/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour;

import com.google.common.base.MoreObjects;
import java.util.Map;
import java.util.Objects;
import org.onosproject.net.behaviour.MirroringName;

public final class MirroringStatistics {
    private MirroringName mirroringName;
    private int txBytes;
    private int txPackets;

    private MirroringStatistics(String name, int bytes, int packets) {
        this.mirroringName = MirroringName.mirroringName(name);
        this.txBytes = bytes;
        this.txPackets = packets;
    }

    public static MirroringStatistics mirroringStatistics(String name, Map<String, Integer> statistics) {
        return new MirroringStatistics(name, statistics.get("tx_bytes"), statistics.get("tx_packets"));
    }

    public MirroringName name() {
        return this.mirroringName;
    }

    public long bytes() {
        return this.txBytes;
    }

    public long packtes() {
        return this.txPackets;
    }

    public int hashCode() {
        return Objects.hash(this.name().name(), this.txBytes, this.txPackets);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MirroringStatistics) {
            MirroringStatistics that = (MirroringStatistics)obj;
            return this.getClass() == that.getClass() && Objects.equals(this.mirroringName, that.mirroringName) && Objects.equals(this.txBytes, that.txBytes) && Objects.equals(this.txPackets, that.txPackets);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("name", (Object)this.name()).add("tx_bytes", this.bytes()).add("tx_packets", this.packtes()).toString();
    }
}

