/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.config.basics;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import org.onlab.util.Bandwidth;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class BandwidthCapacity
extends Config<ConnectPoint> {
    public static final String CONFIG_KEY = "bandwidthCapacity";
    private static final String CAPACITY = "capacityMbps";
    private static final Logger log = LoggerFactory.getLogger(BandwidthCapacity.class);

    @Override
    public boolean isValid() {
        return this.isNumber(CAPACITY, Config.FieldPresence.MANDATORY, new long[0]);
    }

    public BandwidthCapacity capacity(Bandwidth bandwidth) {
        Preconditions.checkNotNull((Object)bandwidth);
        this.setOrClear(CAPACITY, bandwidth.bps());
        return this;
    }

    public Bandwidth capacity() {
        JsonNode v = this.object.path(CAPACITY);
        if (v.isIntegralNumber()) {
            return Bandwidth.mbps((long)v.asLong());
        }
        if (v.isFloatingPointNumber()) {
            return Bandwidth.mbps((double)v.asDouble());
        }
        log.warn("Unexpected JsonNode for {}: {}", (Object)CAPACITY, (Object)v);
        return Bandwidth.mbps((double)v.asDouble());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("capacity", (Object)this.capacity()).toString();
    }
}

