/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.config.basics;

import com.google.common.base.MoreObjects;
import org.onosproject.net.config.Config;
import org.onosproject.net.config.InvalidFieldException;
import org.onosproject.net.region.RegionId;
import org.onosproject.ui.model.topo.UiTopoLayoutId;

public class BasicUiTopoLayoutConfig
extends Config<UiTopoLayoutId> {
    static final String REGION = "region";
    static final String PARENT = "parent";
    static final String GEOMAP = "geomap";
    static final String SPRITES = "sprites";
    static final String SCALE = "scale";
    static final String OFFSET_X = "offsetX";
    static final String OFFSET_Y = "offsetY";
    static final double DEFAULT_SCALE = 1.0;
    static final double DEFAULT_OFFSET = 0.0;
    private static final String E_GEOMAP_SPRITE = "Layout cannot have both geomap and sprites defined";
    private static final String E_SPRITES_ALREADY_SET = "Can't set geomap when sprites is already set";
    private static final String E_GEOMAP_ALREADY_SET = "Can't set sprites when geomap is already set";

    @Override
    public boolean isValid() {
        if (this.object.has(GEOMAP) && this.object.has(SPRITES)) {
            throw new InvalidFieldException(GEOMAP, E_GEOMAP_SPRITE);
        }
        return this.hasOnlyFields(REGION, PARENT, GEOMAP, SPRITES, SCALE, OFFSET_X, OFFSET_Y);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add(REGION, (Object)this.region()).add(PARENT, (Object)this.parent()).add(GEOMAP, (Object)this.geomap()).add(SPRITES, (Object)this.sprites()).add(SCALE, this.scale()).add("offX", this.offsetX()).add("offY", this.offsetY()).toString();
    }

    public RegionId region() {
        String r = this.get(REGION, null);
        return r == null ? null : RegionId.regionId(r);
    }

    public BasicUiTopoLayoutConfig region(RegionId id) {
        this.setOrClear(REGION, id == null ? null : (String)id.id());
        return this;
    }

    public UiTopoLayoutId parent() {
        String p = this.get(PARENT, null);
        return p == null ? UiTopoLayoutId.DEFAULT_ID : UiTopoLayoutId.layoutId(p);
    }

    public BasicUiTopoLayoutConfig parent(UiTopoLayoutId id) {
        this.setOrClear(PARENT, id == null ? null : (String)id.id());
        return this;
    }

    public String geomap() {
        return this.get(GEOMAP, null);
    }

    public BasicUiTopoLayoutConfig geomap(String geomap) {
        if (geomap != null && this.hasField(SPRITES)) {
            throw new InvalidFieldException(GEOMAP, E_SPRITES_ALREADY_SET);
        }
        this.setOrClear(GEOMAP, geomap);
        return this;
    }

    public String sprites() {
        return this.get(SPRITES, null);
    }

    public BasicUiTopoLayoutConfig sprites(String sprites) {
        if (sprites != null && this.hasField(GEOMAP)) {
            throw new InvalidFieldException(GEOMAP, E_GEOMAP_ALREADY_SET);
        }
        this.setOrClear(SPRITES, sprites);
        return this;
    }

    public double scale() {
        return this.get(SCALE, 1.0);
    }

    public BasicUiTopoLayoutConfig scale(Double scale) {
        this.setOrClear(SCALE, scale);
        return this;
    }

    public double offsetX() {
        return this.get(OFFSET_X, 0.0);
    }

    public BasicUiTopoLayoutConfig offsetX(Double offsetX) {
        this.setOrClear(OFFSET_X, offsetX);
        return this;
    }

    public double offsetY() {
        return this.get(OFFSET_Y, 0.0);
    }

    public BasicUiTopoLayoutConfig offsetY(Double offsetY) {
        this.setOrClear(OFFSET_Y, offsetY);
        return this;
    }
}

