/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flowobjective;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveContext;

@Beta
public final class DefaultForwardingObjective
implements ForwardingObjective {
    private final TrafficSelector selector;
    private final ForwardingObjective.Flag flag;
    private final boolean permanent;
    private final int timeout;
    private final ApplicationId appId;
    private final int priority;
    private final Integer nextId;
    private final TrafficTreatment treatment;
    private final Objective.Operation op;
    private final Optional<ObjectiveContext> context;
    private final TrafficSelector meta;
    private final int id;

    private DefaultForwardingObjective(Builder builder) {
        this.selector = builder.selector;
        this.flag = builder.flag;
        this.permanent = builder.permanent;
        this.timeout = builder.timeout;
        this.appId = builder.appId;
        this.priority = builder.priority;
        this.nextId = builder.nextId;
        this.treatment = builder.treatment;
        this.op = builder.op;
        this.context = Optional.ofNullable(builder.context);
        this.meta = builder.meta;
        this.id = Objects.hash(new Object[]{this.selector, this.flag, this.permanent, this.timeout, this.appId, this.priority, this.nextId, this.treatment, this.op});
    }

    @Override
    public TrafficSelector selector() {
        return this.selector;
    }

    @Override
    public Integer nextId() {
        return this.nextId;
    }

    @Override
    public TrafficTreatment treatment() {
        return this.treatment;
    }

    @Override
    public ForwardingObjective.Flag flag() {
        return this.flag;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public int priority() {
        return this.priority;
    }

    @Override
    public ApplicationId appId() {
        return this.appId;
    }

    @Override
    public int timeout() {
        return this.timeout;
    }

    @Override
    public boolean permanent() {
        return this.permanent;
    }

    @Override
    public Objective.Operation op() {
        return this.op;
    }

    @Override
    public Optional<ObjectiveContext> context() {
        return this.context;
    }

    @Override
    public TrafficSelector meta() {
        return this.meta;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.selector, this.flag, this.permanent, this.timeout, this.appId, this.priority, this.nextId, this.treatment, this.op, this.meta});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultForwardingObjective) {
            DefaultForwardingObjective other = (DefaultForwardingObjective)obj;
            return Objects.equals(this.selector, other.selector) && Objects.equals((Object)this.flag, (Object)other.flag) && Objects.equals(this.permanent, other.permanent) && Objects.equals(this.timeout, other.timeout) && Objects.equals(this.appId, other.appId) && Objects.equals(this.priority, other.priority) && Objects.equals(this.nextId, other.nextId) && Objects.equals(this.treatment, other.treatment) && Objects.equals((Object)this.op, (Object)other.op) && Objects.equals(this.meta, other.meta);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.id()).add("op", (Object)this.op()).add("priority", this.priority()).add("selector", (Object)this.selector()).add("treatment", (Object)this.treatment()).add("nextId", (Object)this.nextId()).add("meta", (Object)this.meta()).add("flag", (Object)this.flag()).add("appId", (Object)this.appId()).add("permanent", this.permanent()).add("timeout", this.timeout()).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Builder copy() {
        return new Builder(this);
    }

    public static final class Builder
    implements ForwardingObjective.Builder {
        private TrafficSelector selector;
        private ForwardingObjective.Flag flag;
        private boolean permanent = true;
        private int timeout = 0;
        private int priority = 32768;
        private ApplicationId appId;
        private Integer nextId;
        private TrafficTreatment treatment;
        private Objective.Operation op;
        private ObjectiveContext context;
        private TrafficSelector meta;

        private Builder() {
        }

        private Builder(ForwardingObjective objective) {
            this.selector = objective.selector();
            this.flag = objective.flag();
            this.permanent = objective.permanent();
            this.timeout = objective.timeout();
            this.priority = objective.priority();
            this.appId = objective.appId();
            this.nextId = objective.nextId();
            this.treatment = objective.treatment();
            this.op = objective.op();
            this.meta = objective.meta();
        }

        @Override
        public Builder withSelector(TrafficSelector selector) {
            this.selector = selector;
            return this;
        }

        @Override
        public Builder nextStep(int nextId) {
            this.nextId = nextId;
            return this;
        }

        @Override
        public Builder withTreatment(TrafficTreatment treatment) {
            this.treatment = treatment;
            return this;
        }

        @Override
        public Builder withFlag(ForwardingObjective.Flag flag) {
            this.flag = flag;
            return this;
        }

        @Override
        public Builder makeTemporary(int timeout) {
            this.timeout = timeout;
            this.permanent = false;
            return this;
        }

        @Override
        public Builder makePermanent() {
            this.permanent = true;
            return this;
        }

        @Override
        public Builder fromApp(ApplicationId appId) {
            this.appId = appId;
            return this;
        }

        @Override
        public Builder withPriority(int priority) {
            this.priority = priority;
            return this;
        }

        @Override
        public Builder withMeta(TrafficSelector meta) {
            this.meta = meta;
            return this;
        }

        @Override
        public ForwardingObjective add() {
            Preconditions.checkNotNull((Object)this.selector, (Object)"Must have a selector");
            Preconditions.checkNotNull((Object)((Object)this.flag), (Object)"A flag must be set");
            Preconditions.checkArgument((this.nextId != null || this.treatment != null ? 1 : 0) != 0, (Object)"Must supply at least a treatment and/or a nextId");
            Preconditions.checkNotNull((Object)this.appId, (Object)"Must supply an application id");
            Preconditions.checkArgument((this.priority <= 65535 && this.priority >= 0 ? 1 : 0) != 0, (Object)"Priority out of range");
            this.op = Objective.Operation.ADD;
            return new DefaultForwardingObjective(this);
        }

        @Override
        public ForwardingObjective remove() {
            Preconditions.checkNotNull((Object)this.selector, (Object)"Must have a selector");
            Preconditions.checkNotNull((Object)((Object)this.flag), (Object)"A flag must be set");
            Preconditions.checkArgument((this.nextId != null || this.treatment != null ? 1 : 0) != 0, (Object)"Must supply at least a treatment and/or a nextId");
            Preconditions.checkNotNull((Object)this.appId, (Object)"Must supply an application id");
            this.op = Objective.Operation.REMOVE;
            return new DefaultForwardingObjective(this);
        }

        @Override
        public ForwardingObjective add(ObjectiveContext context) {
            Preconditions.checkNotNull((Object)this.selector, (Object)"Must have a selector");
            Preconditions.checkNotNull((Object)((Object)this.flag), (Object)"A flag must be set");
            Preconditions.checkArgument((this.nextId != null || this.treatment != null ? 1 : 0) != 0, (Object)"Must supply at least a treatment and/or a nextId");
            Preconditions.checkNotNull((Object)this.appId, (Object)"Must supply an application id");
            this.op = Objective.Operation.ADD;
            this.context = context;
            return new DefaultForwardingObjective(this);
        }

        @Override
        public ForwardingObjective remove(ObjectiveContext context) {
            Preconditions.checkNotNull((Object)this.selector, (Object)"Must have a selector");
            Preconditions.checkNotNull((Object)((Object)this.flag), (Object)"A flag must be set");
            Preconditions.checkArgument((this.nextId != null || this.treatment != null ? 1 : 0) != 0, (Object)"Must supply at least a treatment and/or a nextId");
            Preconditions.checkNotNull((Object)this.appId, (Object)"Must supply an application id");
            this.op = Objective.Operation.REMOVE;
            this.context = context;
            return new DefaultForwardingObjective(this);
        }
    }
}

