/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.List;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.Link;
import org.onosproject.net.Path;
import org.onosproject.net.ResourceGroup;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.ConnectivityIntent;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.Key;

@Beta
public class PathIntent
extends ConnectivityIntent {
    private final Path path;
    private ProtectionType type;

    @Deprecated
    protected PathIntent(ApplicationId appId, Key key, TrafficSelector selector, TrafficTreatment treatment, Path path, List<Constraint> constraints, int priority) {
        this(appId, key, selector, treatment, path, constraints, priority, ProtectionType.PRIMARY, null);
    }

    protected PathIntent(ApplicationId appId, Key key, TrafficSelector selector, TrafficTreatment treatment, Path path, List<Constraint> constraints, int priority, ProtectionType type, ResourceGroup resourceGroup) {
        super(appId, key, PathIntent.resources(path.links()), selector, treatment, constraints, priority, resourceGroup);
        PathIntent.validate(path.links());
        this.path = path;
        this.type = type;
    }

    protected PathIntent() {
        this.path = null;
        this.type = ProtectionType.PRIMARY;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static void validate(List<Link> links) {
        Preconditions.checkArgument((boolean)Iterables.all(links, link -> !link.src().elementId().equals(link.dst().elementId())), (String)"element of src and dst in a link must be different: {}", (Object[])new Object[]{links});
        boolean adjacentSame = true;
        for (int i = 0; i < links.size() - 1; ++i) {
            if (links.get(i).dst().elementId().equals(links.get(i + 1).src().elementId())) continue;
            adjacentSame = false;
            break;
        }
        Preconditions.checkArgument((boolean)adjacentSame, (String)"adjacent links must share the same element: {}", (Object[])new Object[]{links});
    }

    public Path path() {
        return this.path;
    }

    public ProtectionType type() {
        return this.type;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("id", (Object)this.id()).add("key", (Object)this.key()).add("appId", (Object)this.appId()).add("priority", this.priority()).add("resources", this.resources()).add("selector", (Object)this.selector()).add("treatment", (Object)this.treatment()).add("constraints", this.constraints()).add("path", (Object)this.path).add("type", (Object)this.type).add("resourceGroup", (Object)this.resourceGroup()).toString();
    }

    @Beta
    public static enum ProtectionType {
        PRIMARY,
        BACKUP,
        FAILOVER;

    }

    public static class Builder
    extends ConnectivityIntent.Builder {
        Path path;
        ProtectionType type;

        protected Builder() {
        }

        @Override
        public Builder appId(ApplicationId appId) {
            return (Builder)super.appId(appId);
        }

        @Override
        public Builder key(Key key) {
            return (Builder)super.key(key);
        }

        @Override
        public Builder selector(TrafficSelector selector) {
            return (Builder)super.selector(selector);
        }

        @Override
        public Builder treatment(TrafficTreatment treatment) {
            return (Builder)super.treatment(treatment);
        }

        @Override
        public Builder constraints(List<Constraint> constraints) {
            return (Builder)super.constraints(constraints);
        }

        @Override
        public Builder priority(int priority) {
            return (Builder)super.priority(priority);
        }

        @Override
        public Builder resourceGroup(ResourceGroup resourceGroup) {
            return (Builder)super.resourceGroup(resourceGroup);
        }

        public Builder path(Path path) {
            this.path = path;
            return this;
        }

        public Builder setType(ProtectionType type) {
            this.type = type;
            return this;
        }

        public PathIntent build() {
            return new PathIntent(this.appId, this.key, this.selector, this.treatment, this.path, this.constraints, this.priority, this.type == null ? ProtectionType.PRIMARY : this.type, this.resourceGroup);
        }
    }
}

