/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.annotation.concurrent.Immutable;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.NetworkResource;
import org.onosproject.net.ResourceGroup;
import org.onosproject.net.behaviour.protection.ProtectedTransportEndpointDescription;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.Key;

@Immutable
@Beta
public class ProtectionEndpointIntent
extends Intent {
    private final DeviceId deviceId;
    private final ProtectedTransportEndpointDescription description;

    @Deprecated
    protected ProtectionEndpointIntent(ApplicationId appId, Key key, Collection<NetworkResource> resources, int priority, DeviceId deviceId, ProtectedTransportEndpointDescription description) {
        super(appId, key, resources, priority, null);
        this.deviceId = (DeviceId)Preconditions.checkNotNull((Object)deviceId);
        this.description = (ProtectedTransportEndpointDescription)Preconditions.checkNotNull((Object)description);
    }

    protected ProtectionEndpointIntent(ApplicationId appId, Key key, Collection<NetworkResource> resources, int priority, DeviceId deviceId, ProtectedTransportEndpointDescription description, ResourceGroup resourceGroup) {
        super(appId, key, resources, priority, resourceGroup);
        this.deviceId = (DeviceId)Preconditions.checkNotNull((Object)deviceId);
        this.description = (ProtectedTransportEndpointDescription)Preconditions.checkNotNull((Object)description);
    }

    public DeviceId deviceId() {
        return this.deviceId;
    }

    public ProtectedTransportEndpointDescription description() {
        return this.description;
    }

    @Override
    public boolean isInstallable() {
        return true;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("id", (Object)this.id()).add("key", (Object)this.key()).add("appId", (Object)this.appId()).add("priority", this.priority()).add("resources", this.resources()).add("deviceId", (Object)this.deviceId).add("description", (Object)this.description).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    private ProtectionEndpointIntent() {
        this.deviceId = null;
        this.description = null;
    }

    public static class Builder
    extends Intent.Builder {
        private DeviceId deviceId;
        private ProtectedTransportEndpointDescription description;

        protected Builder() {
            this.resources = ImmutableList.of();
        }

        protected Builder(ProtectionEndpointIntent intent) {
            super(intent);
        }

        @Override
        public Builder key(Key key) {
            super.key(key);
            return this;
        }

        @Override
        public Builder appId(ApplicationId appId) {
            super.appId(appId);
            return this;
        }

        @Override
        public Builder resources(Collection<NetworkResource> resources) {
            super.resources(resources);
            return this;
        }

        @Override
        public Builder priority(int priority) {
            super.priority(priority);
            return this;
        }

        @Override
        public Builder resourceGroup(ResourceGroup resourceGroup) {
            return (Builder)super.resourceGroup(resourceGroup);
        }

        public Builder deviceId(DeviceId deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public Builder description(ProtectedTransportEndpointDescription description) {
            this.description = description;
            return this;
        }

        public ProtectionEndpointIntent build() {
            Preconditions.checkNotNull((Object)this.key, (Object)"Key inherited from origin Intent expected.");
            return new ProtectionEndpointIntent(this.appId, this.key, this.resources, this.priority, this.deviceId, this.description, this.resourceGroup);
        }
    }
}

