/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.onosproject.net.DeviceId;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flowobjective.DefaultForwardingObjective;
import org.onosproject.net.flowobjective.DefaultNextObjective;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.intent.FlowObjectiveIntent;
import org.onosproject.net.intent.FlowRuleIntent;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentService;

public class IntentFilter {
    private final IntentService intentService;
    private final FlowRuleService flowRuleService;

    public IntentFilter(IntentService intentService, FlowRuleService flowRuleService) {
        this.intentService = intentService;
        this.flowRuleService = flowRuleService;
    }

    private boolean nonEmpty(Collection<?> c) {
        return c != null && !c.isEmpty();
    }

    public List<List<FlowEntry>> readIntentFlows(List<Intent> installables) {
        ArrayList<List<FlowEntry>> paths = new ArrayList<List<FlowEntry>>();
        for (Intent installable : installables) {
            List<FlowEntry> flowEntries;
            if (installable instanceof FlowRuleIntent) {
                flowEntries = this.getFlowEntries((FlowRuleIntent)installable);
                if (!this.nonEmpty(flowEntries)) continue;
                paths.add(flowEntries);
                continue;
            }
            if (!(installable instanceof FlowObjectiveIntent) || !this.nonEmpty(flowEntries = this.getFlowEntries((FlowObjectiveIntent)installable))) continue;
            paths.add(flowEntries);
        }
        return paths;
    }

    private List<FlowEntry> getFlowEntries(FlowRuleIntent intent) {
        ArrayList<FlowEntry> flowEntries = new ArrayList<FlowEntry>();
        Collection<FlowRule> flowRules = intent.flowRules();
        for (FlowRule flowRule : flowRules) {
            FlowEntry flowEntry = this.getFlowEntry(flowRule);
            if (flowEntry == null) continue;
            flowEntries.add(flowEntry);
        }
        return flowEntries;
    }

    private List<FlowEntry> getFlowEntries(FlowObjectiveIntent intent) {
        ArrayList<FlowEntry> flowEntries = new ArrayList<FlowEntry>();
        Iterator<Objective> objectives = intent.objectives().iterator();
        Iterator<DeviceId> devices = intent.devices().iterator();
        DefaultNextObjective nextObjective = null;
        while (objectives.hasNext()) {
            Objective objective = objectives.next();
            DeviceId deviceId = devices.next();
            if (objective instanceof NextObjective) {
                nextObjective = (DefaultNextObjective)objective;
                continue;
            }
            if (!(objective instanceof ForwardingObjective)) continue;
            DefaultForwardingObjective forwardObjective = (DefaultForwardingObjective)objective;
            FlowRule flowRule = DefaultFlowRule.builder().forDevice(deviceId).withSelector(forwardObjective.selector()).withTreatment(nextObjective.next().iterator().next()).withPriority(intent.priority()).fromApp(intent.appId()).makePermanent().build();
            FlowEntry flowEntry = this.getFlowEntry(flowRule);
            if (flowEntry == null) continue;
            flowEntries.add(flowEntry);
        }
        return flowEntries;
    }

    private FlowEntry getFlowEntry(FlowRule flowRule) {
        Iterable<FlowEntry> flowEntries = this.flowRuleService.getFlowEntries(flowRule.deviceId());
        if (flowEntries != null) {
            for (FlowEntry entry : flowEntries) {
                if (!entry.exactMatch(flowRule)) continue;
                return entry;
            }
        }
        return null;
    }
}

