/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.topology;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.net.Link;
import org.onosproject.net.topology.TopologyEdge;
import org.onosproject.net.topology.TopologyVertex;

public class DefaultTopologyEdge
implements TopologyEdge {
    private final Link link;
    private final TopologyVertex src;
    private final TopologyVertex dst;

    public DefaultTopologyEdge(TopologyVertex src, TopologyVertex dst, Link link) {
        this.src = src;
        this.dst = dst;
        this.link = (Link)Preconditions.checkNotNull((Object)link);
    }

    @Override
    public Link link() {
        return this.link;
    }

    public TopologyVertex src() {
        return this.src;
    }

    public TopologyVertex dst() {
        return this.dst;
    }

    public int hashCode() {
        return this.link.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultTopologyEdge) {
            DefaultTopologyEdge other = (DefaultTopologyEdge)obj;
            return Objects.equals(this.link, other.link);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("src", (Object)this.src).add("dst", (Object)this.dst).toString();
    }
}

