/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.function.Function;
import org.onlab.util.ByteArraySizeHashPrinter;

public final class MapUpdate<K, V> {
    private String mapName;
    private Type type;
    private K key;
    private V value;
    private V currentValue;
    private long currentVersion = -1L;

    public String mapName() {
        return this.mapName;
    }

    public Type type() {
        return this.type;
    }

    public K key() {
        return this.key;
    }

    public V value() {
        return this.value;
    }

    public V currentValue() {
        return this.currentValue;
    }

    public long currentVersion() {
        return this.currentVersion;
    }

    public <S, T> MapUpdate<S, T> map(Function<K, S> keyMapper, Function<V, T> valueMapper) {
        return MapUpdate.newBuilder().withMapName(this.mapName).withType(this.type).withKey(keyMapper.apply(this.key)).withValue(this.value == null ? null : (Object)valueMapper.apply(this.value)).withCurrentValue((this.currentValue == null ? null : (Object)valueMapper.apply(this.currentValue))).withCurrentVersion(this.currentVersion).build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("mapName", (Object)this.mapName).add("type", (Object)this.type).add("key", this.key).add("value", this.value instanceof byte[] ? new ByteArraySizeHashPrinter((byte[])this.value) : this.value).add("currentValue", this.currentValue).add("currentVersion", this.currentVersion).toString();
    }

    public static <K, V> Builder<K, V> newBuilder() {
        return new Builder();
    }

    public static final class Builder<K, V> {
        private MapUpdate<K, V> update = new MapUpdate();

        public MapUpdate<K, V> build() {
            this.validateInputs();
            return this.update;
        }

        public Builder<K, V> withMapName(String name) {
            ((MapUpdate)this.update).mapName = (String)Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
            return this;
        }

        public Builder<K, V> withType(Type type) {
            ((MapUpdate)this.update).type = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"type cannot be null"));
            return this;
        }

        public Builder<K, V> withKey(K key) {
            ((MapUpdate)this.update).key = Preconditions.checkNotNull(key, (Object)"key cannot be null");
            return this;
        }

        public Builder<K, V> withCurrentValue(V value) {
            ((MapUpdate)this.update).currentValue = value;
            return this;
        }

        public Builder<K, V> withValue(V value) {
            ((MapUpdate)this.update).value = value;
            return this;
        }

        public Builder<K, V> withCurrentVersion(long version) {
            ((MapUpdate)this.update).currentVersion = version;
            return this;
        }

        private void validateInputs() {
            Preconditions.checkNotNull((Object)((Object)((MapUpdate)this.update).type), (Object)"type must be specified");
            Preconditions.checkNotNull((Object)((MapUpdate)this.update).key, (Object)"key must be specified");
            switch (((MapUpdate)this.update).type) {
                case PUT: 
                case PUT_IF_ABSENT: {
                    Preconditions.checkNotNull((Object)((MapUpdate)this.update).value, (Object)"value must be specified.");
                    break;
                }
                case PUT_IF_VERSION_MATCH: {
                    Preconditions.checkNotNull((Object)((MapUpdate)this.update).value, (Object)"value must be specified.");
                    Preconditions.checkState((((MapUpdate)this.update).currentVersion >= 0L ? 1 : 0) != 0, (Object)"current version must be specified");
                    break;
                }
                case PUT_IF_VALUE_MATCH: {
                    Preconditions.checkNotNull((Object)((MapUpdate)this.update).value, (Object)"value must be specified.");
                    Preconditions.checkNotNull((Object)((MapUpdate)this.update).currentValue, (Object)"currentValue must be specified.");
                    break;
                }
                case REMOVE: {
                    break;
                }
                case REMOVE_IF_VERSION_MATCH: {
                    Preconditions.checkState((((MapUpdate)this.update).currentVersion >= 0L ? 1 : 0) != 0, (Object)"current version must be specified");
                    break;
                }
                case REMOVE_IF_VALUE_MATCH: {
                    Preconditions.checkNotNull((Object)((MapUpdate)this.update).currentValue, (Object)"currentValue must be specified.");
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown operation type");
                }
            }
        }
    }

    public static enum Type {
        PUT,
        PUT_IF_ABSENT,
        PUT_IF_VERSION_MATCH,
        PUT_IF_VALUE_MATCH,
        REMOVE,
        REMOVE_IF_VERSION_MATCH,
        REMOVE_IF_VALUE_MATCH;

    }
}

