/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service;

import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.onosproject.store.primitives.DefaultConsistentMap;
import org.onosproject.store.primitives.TransactionId;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.DistributedPrimitive;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.MapTransaction;
import org.onosproject.store.service.Versioned;

public interface AsyncConsistentMap<K, V>
extends DistributedPrimitive {
    @Override
    default public DistributedPrimitive.Type primitiveType() {
        return DistributedPrimitive.Type.CONSISTENT_MAP;
    }

    @Override
    default public CompletableFuture<Void> destroy() {
        return this.clear();
    }

    public CompletableFuture<Integer> size();

    default public CompletableFuture<Boolean> isEmpty() {
        return this.size().thenApply(s -> s == 0);
    }

    public CompletableFuture<Boolean> containsKey(K var1);

    public CompletableFuture<Boolean> containsValue(V var1);

    public CompletableFuture<Versioned<V>> get(K var1);

    default public CompletableFuture<Versioned<V>> computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.computeIf(key, Objects::isNull, (k, v) -> mappingFunction.apply((Object)k));
    }

    default public CompletableFuture<Versioned<V>> computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.computeIf(key, Objects::nonNull, remappingFunction);
    }

    default public CompletableFuture<Versioned<V>> compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.computeIf(key, v -> true, remappingFunction);
    }

    public CompletableFuture<Versioned<V>> computeIf(K var1, Predicate<? super V> var2, BiFunction<? super K, ? super V, ? extends V> var3);

    public CompletableFuture<Versioned<V>> put(K var1, V var2);

    public CompletableFuture<Versioned<V>> putAndGet(K var1, V var2);

    public CompletableFuture<Versioned<V>> remove(K var1);

    public CompletableFuture<Void> clear();

    public CompletableFuture<Set<K>> keySet();

    public CompletableFuture<Collection<Versioned<V>>> values();

    public CompletableFuture<Set<Map.Entry<K, Versioned<V>>>> entrySet();

    public CompletableFuture<Versioned<V>> putIfAbsent(K var1, V var2);

    public CompletableFuture<Boolean> remove(K var1, V var2);

    public CompletableFuture<Boolean> remove(K var1, long var2);

    public CompletableFuture<Versioned<V>> replace(K var1, V var2);

    public CompletableFuture<Boolean> replace(K var1, V var2, V var3);

    public CompletableFuture<Boolean> replace(K var1, long var2, V var4);

    default public CompletableFuture<Void> addListener(MapEventListener<K, V> listener) {
        return this.addListener(listener, MoreExecutors.directExecutor());
    }

    public CompletableFuture<Void> addListener(MapEventListener<K, V> var1, Executor var2);

    public CompletableFuture<Void> removeListener(MapEventListener<K, V> var1);

    public CompletableFuture<Boolean> prepare(MapTransaction<K, V> var1);

    public CompletableFuture<Void> commit(TransactionId var1);

    public CompletableFuture<Void> rollback(TransactionId var1);

    public CompletableFuture<Boolean> prepareAndCommit(MapTransaction<K, V> var1);

    default public ConsistentMap<K, V> asConsistentMap() {
        return this.asConsistentMap(5000L);
    }

    default public ConsistentMap<K, V> asConsistentMap(long timeoutMillis) {
        return new DefaultConsistentMap(this, timeoutMillis);
    }
}

