/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.onlab.osgi.ServiceDirectory;
import org.onosproject.ui.JsonUtils;
import org.onosproject.ui.RequestHandler;
import org.onosproject.ui.UiConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UiMessageHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<String, RequestHandler> handlerMap = new HashMap<String, RequestHandler>();
    private final ObjectMapper mapper = new ObjectMapper();
    private UiConnection connection;
    private ServiceDirectory directory;

    protected abstract Collection<RequestHandler> createRequestHandlers();

    public Set<String> messageTypes() {
        return Collections.unmodifiableSet(this.handlerMap.keySet());
    }

    public void process(ObjectNode message) {
        String type = JsonUtils.eventType(message);
        ObjectNode payload = JsonUtils.payload(message);
        this.exec(type, payload);
    }

    void exec(String eventType, ObjectNode payload) {
        RequestHandler requestHandler = this.handlerMap.get(eventType);
        if (requestHandler != null) {
            requestHandler.process(payload);
        } else {
            this.log.warn("no request handler for event type {}", (Object)eventType);
        }
    }

    public void init(UiConnection connection, ServiceDirectory directory) {
        this.connection = connection;
        this.directory = directory;
        Collection<RequestHandler> handlers = this.createRequestHandlers();
        Preconditions.checkNotNull(handlers, (Object)"Handlers cannot be null");
        Preconditions.checkArgument((!handlers.isEmpty() ? 1 : 0) != 0, (Object)"Handlers cannot be empty");
        for (RequestHandler h : handlers) {
            h.setParent(this);
            this.handlerMap.put(h.eventType(), h);
        }
    }

    public void destroy() {
        this.connection = null;
        this.directory = null;
        this.handlerMap.clear();
    }

    public UiConnection connection() {
        return this.connection;
    }

    public ServiceDirectory directory() {
        return this.directory;
    }

    protected <T> T get(Class<T> serviceClass) {
        return (T)this.directory.get(serviceClass);
    }

    protected ObjectNode objectNode() {
        return this.mapper.createObjectNode();
    }

    protected ArrayNode arrayNode() {
        return this.mapper.createArrayNode();
    }

    protected synchronized void sendMessage(ObjectNode data) {
        UiConnection connection = this.connection();
        if (connection != null) {
            connection.sendMessage(data);
        }
    }
}

