/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.chart;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ChartModel {
    private final Set<String> seriesSet;
    private final String[] seriesArray;
    private final List<Object> labels = Lists.newArrayList();
    private final List<DataPoint> dataPoints = Lists.newArrayList();
    private final Map<String, Annot> annotations = new HashMap<String, Annot>();

    public ChartModel(String ... series) {
        Preconditions.checkNotNull((Object)series, (Object)"series cannot be null");
        Preconditions.checkArgument((series.length > 0 ? 1 : 0) != 0, (Object)"must be at least one series");
        this.seriesSet = Sets.newHashSet((Object[])series);
        if (this.seriesSet.size() != series.length) {
            throw new IllegalArgumentException("duplicate series detected");
        }
        this.seriesArray = Arrays.copyOf(series, series.length);
    }

    private void checkDataPoint(DataPoint dataPoint) {
        Preconditions.checkArgument((dataPoint.size() == this.seriesCount() ? 1 : 0) != 0, (Object)"data size should be equal to number of series");
    }

    private void checkSeries(String series) {
        Preconditions.checkNotNull((Object)series, (Object)"must provide a series name");
        if (!this.seriesSet.contains(series)) {
            throw new IllegalArgumentException("unknown series: " + series);
        }
    }

    public int seriesCount() {
        return this.seriesSet.size();
    }

    public DataPoint addDataPoint(Object label) {
        DataPoint dp = new DataPoint();
        this.labels.add(label);
        this.dataPoints.add(dp);
        return dp;
    }

    public String[] getSeries() {
        return this.seriesArray;
    }

    public DataPoint[] getDataPoints() {
        return this.dataPoints.toArray(new DataPoint[this.dataPoints.size()]);
    }

    public Object[] getLabels() {
        return this.labels.toArray(new Object[this.labels.size()]);
    }

    public int dataPointCount() {
        return this.dataPoints.size();
    }

    public DataPoint getLastDataPoint() {
        return this.dataPoints.get(this.dataPoints.size() - 1);
    }

    public void addAnnotation(String key, Object value) {
        this.annotations.put(key, new Annot(key, value));
    }

    public Collection<Annot> getAnnotations() {
        return new ArrayList<Annot>(this.annotations.values());
    }

    public class DataPoint {
        private final Map<String, Object> data = Maps.newHashMap();

        public DataPoint data(String series, Object value) {
            ChartModel.this.checkSeries(series);
            this.data.put(series, value);
            return this;
        }

        public Object get(String series) {
            return this.data.get(series);
        }

        public Object[] getAll() {
            Object[] value = new Object[ChartModel.this.getSeries().length];
            int idx = 0;
            for (String s : ChartModel.this.getSeries()) {
                value[idx] = this.get(s);
                ++idx;
            }
            return value;
        }

        public int size() {
            return this.data.size();
        }

        public String getAsString(String series) {
            return this.get(series).toString();
        }

        public String[] getAsStrings() {
            ArrayList<String> formatted = new ArrayList<String>(this.size());
            for (String c : ChartModel.this.seriesArray) {
                formatted.add(this.getAsString(c));
            }
            return formatted.toArray(new String[formatted.size()]);
        }
    }

    public class Annot {
        private final String key;
        private final Object value;

        public Annot(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        public String key() {
            return this.key;
        }

        public Object value() {
            return this.value;
        }

        public String valueAsString() {
            return this.value.toString();
        }
    }
}

