/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.topo;

import java.text.DecimalFormat;
import org.onosproject.net.Link;
import org.onosproject.net.LinkKey;

public final class TopoUtils {
    public static final double KILO = 1024.0;
    public static final double MEGA = 1048576.0;
    public static final double GIGA = 1.073741824E9;
    public static final String GBITS_UNIT = "Gb";
    public static final String MBITS_UNIT = "Mb";
    public static final String KBITS_UNIT = "Kb";
    public static final String BITS_UNIT = "b";
    public static final String GBYTES_UNIT = "GB";
    public static final String MBYTES_UNIT = "MB";
    public static final String KBYTES_UNIT = "KB";
    public static final String BYTES_UNIT = "B";
    private static final DecimalFormat DF2 = new DecimalFormat("#,###.##");
    private static final String COMPACT = "%s/%s-%s/%s";
    private static final String EMPTY = "";
    private static final String SPACE = " ";
    private static final String PER_SEC = "ps";
    private static final String FLOW = "flow";
    private static final String FLOWS = "flows";

    private TopoUtils() {
    }

    public static String compactLinkString(Link link) {
        return String.format(COMPACT, link.src().elementId(), link.src().port(), link.dst().elementId(), link.dst().port());
    }

    public static LinkKey canonicalLinkKey(Link link) {
        String dn;
        String sn = link.src().elementId().toString();
        return sn.compareTo(dn = link.dst().elementId().toString()) < 0 ? LinkKey.linkKey(link.src(), link.dst()) : LinkKey.linkKey(link.dst(), link.src());
    }

    public static String formatBytes(long bytes) {
        String unit;
        double value;
        if ((double)bytes > 1.073741824E9) {
            value = (double)bytes / 1.073741824E9;
            unit = GBYTES_UNIT;
        } else if ((double)bytes > 1048576.0) {
            value = (double)bytes / 1048576.0;
            unit = MBYTES_UNIT;
        } else if ((double)bytes > 1024.0) {
            value = (double)bytes / 1024.0;
            unit = KBYTES_UNIT;
        } else {
            value = bytes;
            unit = BYTES_UNIT;
        }
        return DF2.format(value) + SPACE + unit;
    }

    public static String formatBitRate(long bytes) {
        String unit;
        double value;
        long bits = bytes * 8L;
        if ((double)bits > 1.073741824E9) {
            value = (double)bits / 1.073741824E9;
            unit = GBITS_UNIT;
            if (value > 10.0) {
                value = 10.0;
            }
        } else if ((double)bits > 1048576.0) {
            value = (double)bits / 1048576.0;
            unit = MBITS_UNIT;
        } else if ((double)bits > 1024.0) {
            value = (double)bits / 1024.0;
            unit = KBITS_UNIT;
        } else {
            value = bits;
            unit = BITS_UNIT;
        }
        return DF2.format(value) + SPACE + unit + PER_SEC;
    }

    public static String formatFlows(long flows) {
        if (flows < 1L) {
            return EMPTY;
        }
        return String.valueOf(flows) + SPACE + (flows > 1L ? FLOWS : FLOW);
    }
}

