/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.model.topo;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.IpAddress;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.DefaultControllerNode;
import org.onosproject.cluster.NodeId;
import org.onosproject.ui.model.AbstractUiModelTest;
import org.onosproject.ui.model.topo.UiClusterMember;
import org.onosproject.ui.model.topo.UiTopology;

public class UiClusterMemberTest
extends AbstractUiModelTest {
    private static final NodeId NODE_ID = NodeId.nodeId((String)"Node-1");
    private static final IpAddress NODE_IP = IpAddress.valueOf((String)"1.2.3.4");
    private static final ControllerNode CNODE_1 = new DefaultControllerNode(NODE_ID, NODE_IP);
    private UiTopology topo;
    private UiClusterMember member;

    @Before
    public void setUp() {
        this.topo = new UiTopology();
    }

    @Test
    public void basic() {
        UiClusterMemberTest.title("basic");
        this.member = new UiClusterMember(this.topo, CNODE_1);
        UiClusterMemberTest.print(this.member);
        Assert.assertEquals((String)"wrong id", (Object)NODE_ID, (Object)this.member.id());
        Assert.assertEquals((String)"wrong IP", (Object)NODE_IP, (Object)this.member.ip());
        Assert.assertEquals((String)"unex. online", (Object)false, (Object)this.member.isOnline());
        Assert.assertEquals((String)"unex. ready", (Object)false, (Object)this.member.isReady());
    }
}

