/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.device;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.onosproject.net.AbstractDescription;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.PortDescription;

public class DefaultPortDescription
extends AbstractDescription
implements PortDescription {
    private static final long DEFAULT_SPEED = 1000L;
    private final PortNumber number;
    private final boolean isEnabled;
    private final boolean isRemoved;
    private final Port.Type type;
    private final long portSpeed;

    public DefaultPortDescription(PortNumber number, boolean isEnabled, SparseAnnotations ... annotations) {
        this(number, isEnabled, Port.Type.COPPER, 1000L, annotations);
    }

    public DefaultPortDescription(PortNumber number, boolean isEnabled, Port.Type type, long portSpeed, SparseAnnotations ... annotations) {
        this(number, isEnabled, false, type, portSpeed, annotations);
    }

    public DefaultPortDescription(PortNumber number, boolean isEnabled, boolean isRemoved, Port.Type type, long portSpeed, SparseAnnotations ... annotations) {
        super(annotations);
        this.number = (PortNumber)Preconditions.checkNotNull((Object)number);
        this.isEnabled = isEnabled;
        this.isRemoved = isRemoved;
        this.type = type;
        this.portSpeed = portSpeed;
    }

    protected DefaultPortDescription() {
        this.number = null;
        this.isEnabled = false;
        this.isRemoved = false;
        this.portSpeed = 1000L;
        this.type = Port.Type.COPPER;
    }

    public DefaultPortDescription(PortDescription base, SparseAnnotations annotations) {
        this(base.portNumber(), base.isEnabled(), base.type(), base.portSpeed(), annotations);
    }

    @Override
    public PortNumber portNumber() {
        return this.number;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public boolean isRemoved() {
        return this.isRemoved;
    }

    @Override
    public Port.Type type() {
        return this.type;
    }

    @Override
    public long portSpeed() {
        return this.portSpeed;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("number", (Object)this.number).add("isEnabled", this.isEnabled).add("type", (Object)this.type).add("portSpeed", this.portSpeed).add("annotations", (Object)this.annotations()).toString();
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.number, this.isEnabled, this.type, this.portSpeed});
    }

    @Override
    public boolean equals(Object object) {
        if (object != null && this.getClass() == object.getClass()) {
            if (!super.equals(object)) {
                return false;
            }
            DefaultPortDescription that = (DefaultPortDescription)object;
            return Objects.equal((Object)this.number, (Object)that.number) && Objects.equal((Object)this.isEnabled, (Object)that.isEnabled) && Objects.equal((Object)((Object)this.type), (Object)((Object)that.type)) && Objects.equal((Object)this.portSpeed, (Object)that.portSpeed);
        }
        return false;
    }
}

