/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.FilteredConnectPoint;
import org.onosproject.net.NetworkResource;
import org.onosproject.net.ResourceGroup;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.ConnectivityIntent;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class SinglePointToMultiPointIntent
extends ConnectivityIntent {
    private final FilteredConnectPoint ingressPoint;
    private final Set<FilteredConnectPoint> egressPoints;

    private SinglePointToMultiPointIntent(ApplicationId appId, Key key, TrafficSelector selector, TrafficTreatment treatment, FilteredConnectPoint ingressPoint, Set<FilteredConnectPoint> egressPoints, List<Constraint> constraints, int priority, ResourceGroup resourceGroup) {
        super(appId, key, (Collection<NetworkResource>)ImmutableList.of(), selector, treatment, constraints, priority, resourceGroup);
        Preconditions.checkNotNull(egressPoints);
        Preconditions.checkNotNull((Object)ingressPoint);
        Preconditions.checkArgument((!egressPoints.isEmpty() ? 1 : 0) != 0, (Object)"Egress point set cannot be empty");
        Preconditions.checkArgument((!egressPoints.contains(ingressPoint) ? 1 : 0) != 0, (String)"Set of egresses should not contain ingress (ingress: %s)", (Object[])new Object[]{ingressPoint});
        this.ingressPoint = ingressPoint;
        this.egressPoints = Sets.newHashSet(egressPoints);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(SinglePointToMultiPointIntent intent) {
        return new Builder(intent);
    }

    protected SinglePointToMultiPointIntent() {
        this.ingressPoint = null;
        this.egressPoints = null;
    }

    public ConnectPoint ingressPoint() {
        return this.ingressPoint.connectPoint();
    }

    public Set<ConnectPoint> egressPoints() {
        return this.egressPoints.stream().map(FilteredConnectPoint::connectPoint).collect(Collectors.toSet());
    }

    public FilteredConnectPoint filteredIngressPoint() {
        return this.ingressPoint;
    }

    public Set<FilteredConnectPoint> filteredEgressPoints() {
        return this.egressPoints;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("id", (Object)this.id()).add("key", (Object)this.key()).add("appId", (Object)this.appId()).add("priority", this.priority()).add("resources", this.resources()).add("selector", (Object)this.selector()).add("treatment", (Object)this.treatment()).add("ingress", (Object)this.ingressPoint).add("egress", this.egressPoints).add("filteredIngressCPs", (Object)this.filteredIngressPoint()).add("filteredEgressCP", this.filteredEgressPoints()).add("constraints", this.constraints()).add("resourceGroup", (Object)this.resourceGroup()).toString();
    }

    public static final class Builder
    extends ConnectivityIntent.Builder {
        private final Logger log = LoggerFactory.getLogger(this.getClass());
        private FilteredConnectPoint ingressPoint;
        private Set<FilteredConnectPoint> egressPoints;

        private Builder() {
        }

        protected Builder(SinglePointToMultiPointIntent intent) {
            super(intent);
            this.filteredEgressPoints(intent.filteredEgressPoints()).filteredIngressPoint(intent.filteredIngressPoint());
        }

        @Override
        public Builder appId(ApplicationId appId) {
            return (Builder)super.appId(appId);
        }

        @Override
        public Builder key(Key key) {
            return (Builder)super.key(key);
        }

        @Override
        public Builder selector(TrafficSelector selector) {
            return (Builder)super.selector(selector);
        }

        @Override
        public Builder treatment(TrafficTreatment treatment) {
            return (Builder)super.treatment(treatment);
        }

        @Override
        public Builder constraints(List<Constraint> constraints) {
            return (Builder)super.constraints(constraints);
        }

        @Override
        public Builder priority(int priority) {
            return (Builder)super.priority(priority);
        }

        @Override
        public Builder resourceGroup(ResourceGroup resourceGroup) {
            return (Builder)super.resourceGroup(resourceGroup);
        }

        @Deprecated
        public Builder ingressPoint(ConnectPoint ingressPoint) {
            if (this.ingressPoint != null) {
                this.log.warn("Ingress point is already set, this will override original ingress point.");
            }
            this.ingressPoint = new FilteredConnectPoint(ingressPoint);
            return this;
        }

        @Deprecated
        public Builder egressPoints(Set<ConnectPoint> egressPoints) {
            if (this.egressPoints != null) {
                this.log.warn("Egress points are already set, this will override original egress points.");
            }
            Set filteredConnectPoints = egressPoints.stream().map(FilteredConnectPoint::new).collect(Collectors.toSet());
            this.egressPoints = ImmutableSet.copyOf(filteredConnectPoints);
            return this;
        }

        public Builder filteredIngressPoint(FilteredConnectPoint ingressPoint) {
            this.ingressPoint = ingressPoint;
            return this;
        }

        public Builder filteredEgressPoints(Set<FilteredConnectPoint> egressPoints) {
            this.egressPoints = ImmutableSet.copyOf(egressPoints);
            return this;
        }

        public SinglePointToMultiPointIntent build() {
            return new SinglePointToMultiPointIntent(this.appId, this.key, this.selector, this.treatment, this.ingressPoint, this.egressPoints, this.constraints, this.priority, this.resourceGroup);
        }
    }
}

