/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.topo;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.onosproject.ui.JsonUtils;
import org.onosproject.ui.topo.ButtonId;
import org.onosproject.ui.topo.DeviceHighlight;
import org.onosproject.ui.topo.Highlights;
import org.onosproject.ui.topo.HostHighlight;
import org.onosproject.ui.topo.LinkHighlight;
import org.onosproject.ui.topo.NodeBadge;
import org.onosproject.ui.topo.PropertyPanel;

public final class TopoJson {
    static final String SHOW_HIGHLIGHTS = "showHighlights";
    static final String DEVICES = "devices";
    static final String HOSTS = "hosts";
    static final String LINKS = "links";
    static final String SUBDUE = "subdue";
    static final String DELAY = "delay";
    static final String ID = "id";
    static final String LABEL = "label";
    static final String CSS = "css";
    static final String BADGE = "badge";
    static final String STATUS = "status";
    static final String TXT = "txt";
    static final String GID = "gid";
    static final String MSG = "msg";
    static final String TITLE = "title";
    static final String TYPE = "type";
    static final String PROP_ORDER = "propOrder";
    static final String PROPS = "props";
    static final String BUTTONS = "buttons";
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private static ObjectNode objectNode() {
        return MAPPER.createObjectNode();
    }

    private static ArrayNode arrayNode() {
        return MAPPER.createArrayNode();
    }

    private TopoJson() {
    }

    public static ObjectNode highlightsMessage(Highlights highlights) {
        return JsonUtils.envelope(SHOW_HIGHLIGHTS, TopoJson.json(highlights));
    }

    public static ObjectNode json(Highlights highlights) {
        int delay;
        ObjectNode payload = TopoJson.objectNode();
        ArrayNode devices = TopoJson.arrayNode();
        ArrayNode hosts = TopoJson.arrayNode();
        ArrayNode links = TopoJson.arrayNode();
        payload.set(DEVICES, (JsonNode)devices);
        payload.set(HOSTS, (JsonNode)hosts);
        payload.set(LINKS, (JsonNode)links);
        highlights.devices().forEach(dh -> devices.add((JsonNode)TopoJson.json(dh)));
        highlights.hosts().forEach(hh -> hosts.add((JsonNode)TopoJson.json(hh)));
        highlights.links().forEach(lh -> links.add((JsonNode)TopoJson.json(lh)));
        Highlights.Amount toSubdue = highlights.subdueLevel();
        if (!toSubdue.equals((Object)Highlights.Amount.ZERO)) {
            payload.put(SUBDUE, toSubdue.toString());
        }
        if ((delay = highlights.delayMs()) > 0) {
            payload.put(DELAY, delay);
        }
        return payload;
    }

    private static ObjectNode json(NodeBadge b) {
        ObjectNode n = TopoJson.objectNode().put(STATUS, b.status().code()).put(b.isGlyph() ? GID : TXT, b.text());
        if (b.message() != null) {
            n.put(MSG, b.message());
        }
        return n;
    }

    private static ObjectNode json(DeviceHighlight dh) {
        NodeBadge badge;
        ObjectNode n = TopoJson.objectNode().put(ID, dh.elementId());
        if (dh.subdued()) {
            n.put(SUBDUE, true);
        }
        if ((badge = dh.badge()) != null) {
            n.set(BADGE, (JsonNode)TopoJson.json(badge));
        }
        return n;
    }

    private static ObjectNode json(HostHighlight hh) {
        NodeBadge badge;
        ObjectNode n = TopoJson.objectNode().put(ID, hh.elementId());
        if (hh.subdued()) {
            n.put(SUBDUE, true);
        }
        if ((badge = hh.badge()) != null) {
            n.set(BADGE, (JsonNode)TopoJson.json(badge));
        }
        return n;
    }

    private static ObjectNode json(LinkHighlight lh) {
        ObjectNode n = TopoJson.objectNode().put(ID, lh.elementId()).put(LABEL, lh.label()).put(CSS, lh.cssClasses());
        if (lh.subdued()) {
            n.put(SUBDUE, true);
        }
        return n;
    }

    public static ObjectNode json(PropertyPanel pp) {
        ObjectNode result = TopoJson.objectNode().put(TITLE, pp.title()).put(TYPE, pp.typeId()).put(ID, pp.id());
        ObjectNode pnode = TopoJson.objectNode();
        ArrayNode porder = TopoJson.arrayNode();
        for (PropertyPanel.Prop p : pp.properties()) {
            porder.add(p.key());
            pnode.put(p.key(), p.value());
        }
        result.set(PROP_ORDER, (JsonNode)porder);
        result.set(PROPS, (JsonNode)pnode);
        ArrayNode buttons = TopoJson.arrayNode();
        for (ButtonId b : pp.buttons()) {
            buttons.add((String)b.id());
        }
        result.set(BUTTONS, (JsonNode)buttons);
        return result;
    }
}

