/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.device;

import com.google.common.testing.EqualsTester;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.device.DefaultPortStatistics;
import org.onosproject.net.device.PortStatistics;

public class DefaultPortStatisticsTest {
    private final PortStatistics stats1 = DefaultPortStatistics.builder().setBytesReceived(1L).setBytesSent(2L).setDurationNano(3L).setDurationSec(4L).setPacketsReceived(5L).setPacketsSent(6L).setPacketsRxDropped(7L).setPacketsRxErrors(8L).setPacketsTxDropped(9L).setPacketsTxErrors(10L).setPort(80).setDeviceId(NetTestTools.did("1")).build();
    private final PortStatistics stats2 = DefaultPortStatistics.builder().setBytesReceived(1L).setBytesSent(2L).setDurationNano(3L).setDurationSec(4L).setPacketsReceived(5L).setPacketsSent(6L).setPacketsRxDropped(7L).setPacketsRxErrors(8L).setPacketsTxDropped(9L).setPacketsTxErrors(11L).setPort(80).setDeviceId(NetTestTools.did("1")).build();

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(DefaultPortStatistics.class);
    }

    @Test
    public void testConstruction() {
        MatcherAssert.assertThat((Object)this.stats1.bytesReceived(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((Object)this.stats1.bytesSent(), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat((Object)this.stats1.durationNano(), (Matcher)Matchers.is((Object)3L));
        MatcherAssert.assertThat((Object)this.stats1.durationSec(), (Matcher)Matchers.is((Object)4L));
        MatcherAssert.assertThat((Object)this.stats1.packetsReceived(), (Matcher)Matchers.is((Object)5L));
        MatcherAssert.assertThat((Object)this.stats1.packetsSent(), (Matcher)Matchers.is((Object)6L));
        MatcherAssert.assertThat((Object)this.stats1.packetsRxDropped(), (Matcher)Matchers.is((Object)7L));
        MatcherAssert.assertThat((Object)this.stats1.packetsRxErrors(), (Matcher)Matchers.is((Object)8L));
        MatcherAssert.assertThat((Object)this.stats1.packetsTxDropped(), (Matcher)Matchers.is((Object)9L));
        MatcherAssert.assertThat((Object)this.stats1.packetsTxErrors(), (Matcher)Matchers.is((Object)10L));
        MatcherAssert.assertThat((Object)this.stats1.port(), (Matcher)Matchers.is((Object)80));
    }

    @Test
    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.stats1, this.stats1}).addEqualityGroup(new Object[]{this.stats2}).testEquals();
    }

    @Test
    public void testSerializerConstructor() {
        try {
            Constructor<?>[] constructors = DefaultPortStatistics.class.getDeclaredConstructors();
            MatcherAssert.assertThat(constructors, (Matcher)Matchers.notNullValue());
            Arrays.stream(constructors).filter(ctor -> ctor.getParameterTypes().length == 0).forEach(noParamsCtor -> {
                try {
                    noParamsCtor.setAccessible(true);
                    DefaultPortStatistics stats = (DefaultPortStatistics)noParamsCtor.newInstance(new Object[0]);
                    MatcherAssert.assertThat((Object)stats, (Matcher)Matchers.notNullValue());
                }
                catch (Exception e) {
                    Assert.fail((String)"Exception instantiating no parameters constructor");
                }
            });
        }
        catch (Exception e) {
            Assert.fail((String)"Exception looking up constructors");
        }
    }
}

