/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.testing.EqualsTester;
import java.time.Duration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.FilteredConnectPoint;
import org.onosproject.net.Link;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.ResourceGroup;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentTest;
import org.onosproject.net.intent.IntentTestsMocks;
import org.onosproject.net.intent.LinkCollectionIntent;
import org.onosproject.net.intent.constraint.LatencyConstraint;

public class LinkCollectionIntentTest
extends IntentTest {
    final ConnectPoint ingress = NetTestTools.connectPoint("ingress", 2);
    final ConnectPoint egress = NetTestTools.connectPoint("egress", 3);
    final TrafficSelector selector = new IntentTestsMocks.MockSelector();
    final IntentTestsMocks.MockTreatment treatment = new IntentTestsMocks.MockTreatment();
    final FilteredConnectPoint filteredIngress = new FilteredConnectPoint(this.ingress);
    final FilteredConnectPoint filteredEgress = new FilteredConnectPoint(this.egress);
    final ResourceGroup resourceGroup = ResourceGroup.of((long)0L);

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(LinkCollectionIntent.class);
    }

    @Test
    public void testEquals() {
        HashSet<Link> links1 = new HashSet<Link>();
        links1.add(NetTestTools.link("src", 1, "dst", 2));
        LinkCollectionIntent collectionIntent1 = LinkCollectionIntent.builder().appId(NetTestTools.APP_ID).selector(this.selector).treatment((TrafficTreatment)this.treatment).links(links1).ingressPoints((Set)ImmutableSet.of((Object)this.ingress)).egressPoints((Set)ImmutableSet.of((Object)this.egress)).resourceGroup(this.resourceGroup).build();
        HashSet<Link> links2 = new HashSet<Link>();
        links2.add(NetTestTools.link("src", 1, "dst", 3));
        LinkCollectionIntent collectionIntent2 = LinkCollectionIntent.builder().appId(NetTestTools.APP_ID).selector(this.selector).treatment((TrafficTreatment)this.treatment).links(links2).ingressPoints((Set)ImmutableSet.of((Object)this.ingress)).egressPoints((Set)ImmutableSet.of((Object)this.egress)).resourceGroup(this.resourceGroup).build();
        new EqualsTester().addEqualityGroup(new Object[]{collectionIntent1}).addEqualityGroup(new Object[]{collectionIntent2}).testEquals();
    }

    @Test
    public void testConstructor() {
        HashSet<Link> links1 = new HashSet<Link>();
        links1.add(NetTestTools.link("src", 1, "dst", 2));
        LinkCollectionIntent collectionIntent = LinkCollectionIntent.builder().appId(NetTestTools.APP_ID).selector(this.selector).treatment((TrafficTreatment)this.treatment).links(links1).ingressPoints((Set)ImmutableSet.of((Object)this.ingress)).egressPoints((Set)ImmutableSet.of((Object)this.egress)).resourceGroup(this.resourceGroup).build();
        Set createdLinks = collectionIntent.links();
        MatcherAssert.assertThat((Object)createdLinks, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)collectionIntent.isInstallable(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)collectionIntent.treatment(), (Matcher)Matchers.is((Object)this.treatment));
        MatcherAssert.assertThat((Object)collectionIntent.selector(), (Matcher)Matchers.is((Object)this.selector));
        MatcherAssert.assertThat((Object)collectionIntent.ingressPoints(), (Matcher)Matchers.is((Object)ImmutableSet.of((Object)this.ingress)));
        MatcherAssert.assertThat((Object)collectionIntent.egressPoints(), (Matcher)Matchers.is((Object)ImmutableSet.of((Object)this.egress)));
        MatcherAssert.assertThat((Object)collectionIntent.resourceGroup(), (Matcher)Matchers.is((Object)this.resourceGroup));
        MatcherAssert.assertThat((Object)collectionIntent.resources(), (Matcher)Matchers.hasSize((int)1));
        List createdConstraints = collectionIntent.constraints();
        MatcherAssert.assertThat((Object)createdConstraints, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void testConstructorWithConstraints() {
        HashSet<Link> links1 = new HashSet<Link>();
        LinkedList<LatencyConstraint> constraints = new LinkedList<LatencyConstraint>();
        links1.add(NetTestTools.link("src", 1, "dst", 2));
        constraints.add(new LatencyConstraint(Duration.ofMillis(100L)));
        LinkCollectionIntent collectionIntent = LinkCollectionIntent.builder().appId(NetTestTools.APP_ID).selector(this.selector).treatment((TrafficTreatment)this.treatment).links(links1).ingressPoints((Set)ImmutableSet.of((Object)this.ingress)).egressPoints((Set)ImmutableSet.of((Object)this.egress)).constraints(constraints).priority(8888).build();
        Set createdLinks = collectionIntent.links();
        MatcherAssert.assertThat((Object)createdLinks, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)collectionIntent.isInstallable(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)collectionIntent.treatment(), (Matcher)Matchers.is((Object)this.treatment));
        MatcherAssert.assertThat((Object)collectionIntent.selector(), (Matcher)Matchers.is((Object)this.selector));
        MatcherAssert.assertThat((Object)collectionIntent.ingressPoints(), (Matcher)Matchers.is((Object)ImmutableSet.of((Object)this.ingress)));
        MatcherAssert.assertThat((Object)collectionIntent.egressPoints(), (Matcher)Matchers.is((Object)ImmutableSet.of((Object)this.egress)));
        List createdConstraints = collectionIntent.constraints();
        MatcherAssert.assertThat((Object)createdConstraints, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(createdConstraints.get(0), (Matcher)Matchers.instanceOf(LatencyConstraint.class));
    }

    @Test
    public void testSerializerConstructor() {
        LinkCollectionIntent collectionIntent = new LinkCollectionIntent();
        Set createdLinks = collectionIntent.links();
        MatcherAssert.assertThat((Object)createdLinks, (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)collectionIntent.isInstallable(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)collectionIntent.treatment(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)collectionIntent.selector(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)collectionIntent.ingressPoints(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)collectionIntent.egressPoints(), (Matcher)Matchers.nullValue());
        List createdConstraints = collectionIntent.constraints();
        MatcherAssert.assertThat((Object)createdConstraints, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void testFilteredConnectedPoint() {
        LinkCollectionIntent intent = this.createFilteredOne();
        HashSet links = Sets.newHashSet();
        links.add(NetTestTools.link("A", 1, "B", 1));
        links.add(NetTestTools.link("A", 2, "C", 1));
        MatcherAssert.assertThat((Object)intent.appId(), (Matcher)Matchers.is((Object)NetTestTools.APP_ID));
        MatcherAssert.assertThat((Object)intent.treatment(), (Matcher)Matchers.is((Object)this.treatment));
        MatcherAssert.assertThat((Object)intent.links(), (Matcher)Matchers.is((Object)links));
        MatcherAssert.assertThat((Object)intent.applyTreatmentOnEgress(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)intent.filteredIngressPoints(), (Matcher)Matchers.is((Object)ImmutableSet.of((Object)this.filteredIngress)));
        MatcherAssert.assertThat((Object)intent.filteredEgressPoints(), (Matcher)Matchers.is((Object)ImmutableSet.of((Object)this.filteredEgress)));
        intent = this.createAnotherFiltered();
        links = Sets.newHashSet();
        links.add(NetTestTools.link("A", 1, "B", 1));
        links.add(NetTestTools.link("A", 2, "C", 1));
        links.add(NetTestTools.link("B", 2, "D", 1));
        links.add(NetTestTools.link("B", 3, "E", 1));
        MatcherAssert.assertThat((Object)intent.appId(), (Matcher)Matchers.is((Object)NetTestTools.APP_ID));
        MatcherAssert.assertThat((Object)intent.treatment(), (Matcher)Matchers.is((Object)this.treatment));
        MatcherAssert.assertThat((Object)intent.links(), (Matcher)Matchers.is((Object)links));
        MatcherAssert.assertThat((Object)intent.applyTreatmentOnEgress(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)intent.filteredIngressPoints(), (Matcher)Matchers.is((Object)ImmutableSet.of((Object)this.filteredIngress)));
        MatcherAssert.assertThat((Object)intent.filteredEgressPoints(), (Matcher)Matchers.is((Object)ImmutableSet.of((Object)this.filteredEgress)));
    }

    @Override
    protected Intent createOne() {
        HashSet<Link> links1 = new HashSet<Link>();
        links1.add(NetTestTools.link("src", 1, "dst", 2));
        return LinkCollectionIntent.builder().appId(NetTestTools.APP_ID).selector(this.selector).treatment((TrafficTreatment)this.treatment).links(links1).ingressPoints((Set)ImmutableSet.of((Object)this.ingress)).egressPoints((Set)ImmutableSet.of((Object)this.egress)).build();
    }

    @Override
    protected Intent createAnother() {
        HashSet<Link> links2 = new HashSet<Link>();
        links2.add(NetTestTools.link("src", 1, "dst", 3));
        return LinkCollectionIntent.builder().appId(NetTestTools.APP_ID).selector(this.selector).treatment((TrafficTreatment)this.treatment).links(links2).ingressPoints((Set)ImmutableSet.of((Object)this.ingress)).egressPoints((Set)ImmutableSet.of((Object)this.egress)).build();
    }

    protected LinkCollectionIntent createFilteredOne() {
        HashSet links = Sets.newHashSet();
        links.add(NetTestTools.link("A", 1, "B", 1));
        links.add(NetTestTools.link("A", 2, "C", 1));
        return LinkCollectionIntent.builder().appId(NetTestTools.APP_ID).treatment((TrafficTreatment)this.treatment).links((Set)links).filteredIngressPoints((Set)ImmutableSet.of((Object)this.filteredIngress)).filteredEgressPoints((Set)ImmutableSet.of((Object)this.filteredEgress)).build();
    }

    protected LinkCollectionIntent createAnotherFiltered() {
        HashSet links = Sets.newHashSet();
        links.add(NetTestTools.link("A", 1, "B", 1));
        links.add(NetTestTools.link("A", 2, "C", 1));
        links.add(NetTestTools.link("B", 2, "D", 1));
        links.add(NetTestTools.link("B", 3, "E", 1));
        return LinkCollectionIntent.builder().appId(NetTestTools.APP_ID).treatment((TrafficTreatment)this.treatment).links((Set)links).applyTreatmentOnEgress(true).filteredIngressPoints((Set)ImmutableSet.of((Object)this.filteredIngress)).filteredEgressPoints((Set)ImmutableSet.of((Object)this.filteredEgress)).build();
    }
}

