/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.testing.EqualsTester;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsEqual;
import org.junit.Before;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onlab.packet.MplsLabel;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.AbstractIntentTest;
import org.onosproject.net.intent.IntentTestsMocks;
import org.onosproject.net.intent.MplsIntent;

public class MplsIntentTest
extends AbstractIntentTest {
    static final int PRIORITY = 22;
    MplsIntent intent1;
    MplsIntent intent2;
    Optional<MplsLabel> label1;
    Optional<MplsLabel> label2;
    TrafficSelector selector;
    TrafficTreatment treatment;

    @Before
    public void mplsIntentTestSetUp() throws Exception {
        this.label1 = Optional.of(MplsLabel.mplsLabel((int)1));
        this.label2 = Optional.of(MplsLabel.mplsLabel((int)2));
        this.selector = new IntentTestsMocks.MockSelector();
        this.treatment = new IntentTestsMocks.MockTreatment();
        this.intent1 = MplsIntent.builder().appId(NetTestTools.APP_ID).ingressLabel(this.label1).egressLabel(this.label2).ingressPoint(NetTestTools.connectPoint("in", 1)).egressPoint(NetTestTools.connectPoint("out", 1)).selector(this.selector).treatment(this.treatment).priority(22).build();
        this.intent2 = MplsIntent.builder().appId(NetTestTools.APP_ID).ingressLabel(this.label1).egressLabel(this.label2).ingressPoint(NetTestTools.connectPoint("in", 2)).egressPoint(NetTestTools.connectPoint("out", 2)).selector(this.selector).treatment(this.treatment).priority(22).build();
    }

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(MplsIntent.class);
    }

    @Test
    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.intent1}).addEqualityGroup(new Object[]{this.intent2}).testEquals();
    }

    @Test
    public void testContents() {
        MatcherAssert.assertThat((Object)this.intent1.appId(), (Matcher)IsEqual.equalTo((Object)NetTestTools.APP_ID));
        MatcherAssert.assertThat((Object)this.intent1.ingressLabel(), (Matcher)IsEqual.equalTo(this.label1));
        MatcherAssert.assertThat((Object)this.intent1.egressLabel(), (Matcher)IsEqual.equalTo(this.label2));
        MatcherAssert.assertThat((Object)this.intent1.ingressPoint(), (Matcher)IsEqual.equalTo((Object)NetTestTools.connectPoint("in", 1)));
        MatcherAssert.assertThat((Object)this.intent1.egressPoint(), (Matcher)IsEqual.equalTo((Object)NetTestTools.connectPoint("out", 1)));
        MatcherAssert.assertThat((Object)this.intent1.selector(), (Matcher)IsEqual.equalTo((Object)this.intent2.selector()));
        MatcherAssert.assertThat((Object)this.intent1.treatment(), (Matcher)IsEqual.equalTo((Object)this.intent2.treatment()));
        MatcherAssert.assertThat((Object)this.intent1.priority(), (Matcher)Matchers.is((Object)22));
    }
}

