/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.config.basics;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.time.Duration;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Link;
import org.onosproject.net.LinkKey;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.config.ConfigApplyDelegate;
import org.onosproject.net.config.basics.BasicLinkConfig;

public class BasicLinkConfigTest {
    private static final long BANDWIDTH = 11L;
    private static final double METRIC = 3.0;
    private static final Duration LATENCY = Duration.ofNanos(5555L);

    @Test
    public void testConstruction() {
        BasicLinkConfig config = new BasicLinkConfig();
        ConfigApplyDelegate delegate = configApply -> {};
        ObjectMapper mapper = new ObjectMapper();
        LinkKey linkKey = LinkKey.linkKey((ConnectPoint)NetTestTools.connectPoint("device1", 1), (ConnectPoint)NetTestTools.connectPoint("device2", 2));
        config.init((Object)linkKey, "KEY", (JsonNode)JsonNodeFactory.instance.objectNode(), mapper, delegate);
        config.bandwidth(Long.valueOf(11L)).isDurable(Boolean.FALSE).metric(Double.valueOf(3.0)).type(Link.Type.DIRECT).latency(LATENCY).isBidirectional(Boolean.FALSE);
        MatcherAssert.assertThat((Object)config.bandwidth(), (Matcher)Matchers.is((Object)11L));
        MatcherAssert.assertThat((Object)config.isDurable(), (Matcher)Matchers.is((Object)Boolean.FALSE));
        MatcherAssert.assertThat((Object)config.metric(), (Matcher)Matchers.is((Object)3.0));
        MatcherAssert.assertThat((Object)config.type(), (Matcher)Matchers.is((Object)Link.Type.DIRECT));
        MatcherAssert.assertThat((Object)config.latency(), (Matcher)Matchers.is((Object)LATENCY));
        MatcherAssert.assertThat((Object)config.isBidirectional(), (Matcher)Matchers.is((Object)Boolean.FALSE));
        MatcherAssert.assertThat((Object)config.isValid(), (Matcher)Matchers.is((Object)true));
    }
}

