/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.neighbour;

import java.util.Set;
import org.onlab.packet.VlanId;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.host.HostService;
import org.onosproject.net.neighbour.NeighbourMessageContext;
import org.onosproject.net.neighbour.NeighbourMessageHandler;

public class DefaultNeighbourMessageHandler
implements NeighbourMessageHandler {
    @Override
    public void handleMessage(NeighbourMessageContext context, HostService hostService) {
        switch (context.type()) {
            case REPLY: {
                Host h = hostService.getHost(HostId.hostId(context.packet().getDestinationMAC(), VlanId.vlanId((short)context.packet().getVlanID())));
                if (h == null) {
                    context.flood();
                    break;
                }
                context.forward(h.location());
                break;
            }
            case REQUEST: {
                Set<Host> hosts = hostService.getHostsByIp(context.target());
                Host dst = null;
                Host src = hostService.getHost(HostId.hostId(context.srcMac(), context.vlan()));
                for (Host host : hosts) {
                    if (!host.vlan().equals((Object)context.vlan())) continue;
                    dst = host;
                    break;
                }
                if (src != null && dst != null) {
                    context.reply(dst.mac());
                    return;
                }
                context.flood();
                break;
            }
        }
    }
}

