/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.event;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.event.BrokenListener;
import org.onosproject.event.Event;
import org.onosproject.event.TestEvent;
import org.onosproject.event.TestListener;
import org.onosproject.event.TestListenerRegistry;

public class ListenerRegistryTest {
    private static final TestEvent FOO_EVENT = new TestEvent(TestEvent.Type.FOO, "foo");
    private static final TestEvent BAR_EVENT = new TestEvent(TestEvent.Type.BAR, "bar");
    private TestListener listener;
    private TestListener secondListener;
    private TestListenerRegistry manager;

    @Before
    public void setUp() {
        this.listener = new TestListener();
        this.secondListener = new TestListener();
        this.manager = new TestListenerRegistry();
    }

    @Test
    public void basics() {
        this.manager.addListener(this.listener);
        this.manager.addListener(this.secondListener);
        this.manager.process((Event)BAR_EVENT);
        Assert.assertTrue((String)"BAR not processed", (boolean)this.listener.events.contains((Object)BAR_EVENT));
        Assert.assertTrue((String)"BAR not processed", (boolean)this.secondListener.events.contains((Object)BAR_EVENT));
        this.manager.removeListener(this.listener);
        this.manager.process((Event)FOO_EVENT);
        Assert.assertFalse((String)"FOO processed", (boolean)this.listener.events.contains((Object)FOO_EVENT));
        Assert.assertTrue((String)"FOO not processed", (boolean)this.secondListener.events.contains((Object)FOO_EVENT));
    }

    @Test
    public void badListener() {
        this.listener = new BrokenListener();
        this.manager.addListener(this.listener);
        this.manager.addListener(this.secondListener);
        this.manager.process((Event)BAR_EVENT);
        Assert.assertFalse((String)"BAR processed", (boolean)this.listener.events.contains((Object)BAR_EVENT));
        Assert.assertFalse((String)"error not reported", (boolean)this.manager.errors.isEmpty());
        Assert.assertTrue((String)"BAR not processed", (boolean)this.secondListener.events.contains((Object)BAR_EVENT));
    }
}

