/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.device;

import com.google.common.testing.EqualsTester;
import java.net.URI;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onlab.packet.ChassisId;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.Device;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DefaultDeviceDescription;
import org.onosproject.net.device.DeviceDescription;

public class DefaultDeviceDescriptionTest {
    private static final URI DURI = URI.create("of:foo");
    private static final String MFR = "whitebox";
    private static final String HW = "1.1.x";
    private static final String SW = "3.9.1";
    private static final String SN = "43311-12345";
    private static final ChassisId CID = new ChassisId();
    private static final DefaultAnnotations DA = DefaultAnnotations.builder().set("Key", "Value").build();
    private static final URI DURI2 = URI.create("of:foo2");
    private static final String MFR2 = "whitebox2";
    private static final String HW2 = "1.1.x2";
    private static final String SW2 = "3.9.12";
    private static final String SN2 = "43311-123452";
    private static final ChassisId CID2 = new ChassisId(2L);
    private static final DefaultAnnotations DA2 = DefaultAnnotations.builder().set("2ndKey", "2ndValue").build();

    private void checkValues(DeviceDescription device, URI uri, Device.Type type, String manufacturer, String hw, String sw, String serial, String containsUri, long chassisId, String annotationsString, boolean defaultAvailable) {
        Assert.assertEquals((String)"incorrect uri", (Object)uri, (Object)device.deviceUri());
        Assert.assertEquals((String)"incorrect type", (Object)type, (Object)device.type());
        Assert.assertEquals((String)"incorrect manufacturer", (Object)device.manufacturer(), (Object)manufacturer);
        Assert.assertEquals((String)"incorrect hw", (Object)device.hwVersion(), (Object)hw);
        Assert.assertEquals((String)"incorrect sw", (Object)device.swVersion(), (Object)sw);
        Assert.assertEquals((String)"incorrect serial", (Object)device.serialNumber(), (Object)serial);
        Assert.assertTrue((String)"incorrect toString", (boolean)device.toString().contains(containsUri));
        Assert.assertTrue((String)"Incorrect chassis", (boolean)(device.chassisId() == null ? chassisId == 0L : chassisId == device.chassisId().value()));
        Assert.assertTrue((String)"incorrect annotations", (boolean)device.toString().contains(annotationsString));
        Assert.assertEquals((String)"incorrect default available", (Object)defaultAvailable, (Object)device.isDefaultAvailable());
    }

    @Test
    public void basics() {
        DefaultDeviceDescription device = new DefaultDeviceDescription(DURI, Device.Type.SWITCH, MFR, HW, SW, SN, CID, new SparseAnnotations[]{DA});
        this.checkValues((DeviceDescription)device, DURI, Device.Type.SWITCH, MFR, HW, SW, SN, "uri=of:foo", CID.value(), "Key=Value", true);
    }

    @Test
    public void testEquals() {
        DefaultDeviceDescription device1 = new DefaultDeviceDescription(DURI, Device.Type.SWITCH, MFR, HW, SW, SN, CID, new SparseAnnotations[]{DA});
        DefaultDeviceDescription sameAsDevice1 = new DefaultDeviceDescription(DURI, Device.Type.SWITCH, MFR, HW, SW, SN, CID, new SparseAnnotations[]{DA});
        DefaultDeviceDescription device2 = new DefaultDeviceDescription(DURI2, Device.Type.SWITCH, MFR, HW, SW, SN, CID, new SparseAnnotations[]{DA});
        DefaultDeviceDescription device3 = new DefaultDeviceDescription(DURI, Device.Type.ROUTER, MFR2, HW, SW, SN, CID, new SparseAnnotations[]{DA});
        DefaultDeviceDescription device4 = new DefaultDeviceDescription(DURI, Device.Type.SWITCH, MFR, HW2, SW, SN, CID, new SparseAnnotations[]{DA});
        DefaultDeviceDescription device5 = new DefaultDeviceDescription(DURI, Device.Type.SWITCH, MFR, HW, SW2, SN, CID, new SparseAnnotations[]{DA});
        DefaultDeviceDescription device6 = new DefaultDeviceDescription(DURI, Device.Type.SWITCH, MFR, HW, SW, SN2, CID, new SparseAnnotations[]{DA});
        DefaultDeviceDescription device7 = new DefaultDeviceDescription(DURI, Device.Type.SWITCH, MFR, HW, SW, SN, CID2, new SparseAnnotations[]{DA});
        DefaultDeviceDescription device8 = new DefaultDeviceDescription(DURI, Device.Type.SWITCH, MFR, HW, SW, SN, CID, new SparseAnnotations[]{DA2});
        new EqualsTester().addEqualityGroup(new Object[]{device1, sameAsDevice1}).addEqualityGroup(new Object[]{device2}).addEqualityGroup(new Object[]{device3}).addEqualityGroup(new Object[]{device4}).addEqualityGroup(new Object[]{device5}).addEqualityGroup(new Object[]{device6}).addEqualityGroup(new Object[]{device7}).addEqualityGroup(new Object[]{device8}).testEquals();
    }

    @Test
    public void testConstructorWithBaseAndAnnotations() {
        DefaultDeviceDescription base = new DefaultDeviceDescription(DURI, Device.Type.SWITCH, MFR, HW, SW, SN, CID, new SparseAnnotations[]{DA});
        DefaultDeviceDescription device = new DefaultDeviceDescription((DeviceDescription)base, new SparseAnnotations[]{DA2});
        this.checkValues((DeviceDescription)device, DURI, Device.Type.SWITCH, MFR, HW, SW, SN, "uri=of:foo", CID.value(), "2ndKey=2ndValue", true);
    }

    @Test
    public void testConstructorWithBaseAndType() {
        DefaultDeviceDescription base = new DefaultDeviceDescription(DURI, Device.Type.ROADM, MFR, HW, SW, SN, CID, new SparseAnnotations[]{DA});
        DefaultDeviceDescription device = new DefaultDeviceDescription((DeviceDescription)base, Device.Type.ROADM, new SparseAnnotations[]{DA});
        this.checkValues((DeviceDescription)device, DURI, Device.Type.ROADM, MFR, HW, SW, SN, "uri=of:foo", CID.value(), "Key=Value", true);
    }

    @Test
    public void testConstructorWithBaseAndIsDefault() {
        DefaultDeviceDescription base = new DefaultDeviceDescription(DURI, Device.Type.SWITCH, MFR, HW, SW, SN, CID, new SparseAnnotations[]{DA});
        DefaultDeviceDescription device = new DefaultDeviceDescription((DeviceDescription)base, false, new SparseAnnotations[]{DA2});
        this.checkValues((DeviceDescription)device, DURI, Device.Type.SWITCH, MFR, HW, SW, SN, "uri=of:foo", CID.value(), "2ndKey=2ndValue", false);
    }

    @Test
    public void testBareConstructor() {
        DefaultDeviceDescription device = new DefaultDeviceDescription();
        this.checkValues((DeviceDescription)device, null, null, null, null, null, null, "uri=null", CID.value(), "", true);
        Assert.assertEquals((String)"incorrect uri", null, (Object)device.deviceUri());
        Assert.assertEquals((String)"incorrect type", null, (Object)device.type());
        Assert.assertEquals((String)"incorrect manufacturer", null, (Object)device.manufacturer());
        Assert.assertEquals((String)"incorrect hw", null, (Object)device.hwVersion());
        Assert.assertEquals((String)"incorrect sw", null, (Object)device.swVersion());
        Assert.assertEquals((String)"incorrect serial", null, (Object)device.serialNumber());
        Assert.assertEquals((String)"Incorrect chassis", null, (Object)device.chassisId());
        Assert.assertEquals((String)"incorrect annotations", null, (Object)device.annotations());
        Assert.assertTrue((String)"incorrect default available", (boolean)device.isDefaultAvailable());
    }

    @Test
    public void testImmutable() {
        ImmutableClassChecker.assertThatClassIsImmutableBaseClass(DefaultDeviceDescription.class);
    }
}

