/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.host;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onosproject.net.host.InterfaceIpAddress;

public class InterfaceIpAddressTest {
    private static final IpAddress IP_ADDRESS = IpAddress.valueOf((String)"1.2.3.4");
    private static final IpPrefix SUBNET_ADDRESS = IpPrefix.valueOf((String)"1.2.0.0/16");
    private static final IpAddress BROADCAST_ADDRESS = IpAddress.valueOf((String)"1.2.0.255");
    private static final IpAddress PEER_ADDRESS = IpAddress.valueOf((String)"5.6.7.8");
    private static final IpAddress DEF_BROADCAST_ADDRESS = IpAddress.valueOf((String)"1.2.255.255");
    private static final IpPrefix V6_SUBNET_ADDRESS = IpPrefix.valueOf((String)"::/64");
    private static final IpAddress IP_ADDRESS2 = IpAddress.valueOf((String)"10.2.3.4");
    private static final IpPrefix SUBNET_ADDRESS2 = IpPrefix.valueOf((String)"10.2.0.0/16");
    private static final IpAddress BROADCAST_ADDRESS2 = IpAddress.valueOf((String)"10.2.0.255");
    private static final IpAddress PEER_ADDRESS2 = IpAddress.valueOf((String)"50.6.7.8");

    @Test
    public void testCopyConstructor() {
        InterfaceIpAddress fromAddr = new InterfaceIpAddress(IP_ADDRESS, SUBNET_ADDRESS);
        InterfaceIpAddress toAddr = new InterfaceIpAddress(fromAddr);
        Assert.assertThat((Object)toAddr.ipAddress(), (Matcher)Matchers.is((Object)fromAddr.ipAddress()));
        Assert.assertThat((Object)toAddr.subnetAddress(), (Matcher)Matchers.is((Object)fromAddr.subnetAddress()));
        Assert.assertThat((Object)toAddr.broadcastAddress(), (Matcher)Matchers.is((Object)fromAddr.broadcastAddress()));
        Assert.assertThat((Object)toAddr.peerAddress(), (Matcher)Matchers.is((Object)fromAddr.peerAddress()));
        fromAddr = new InterfaceIpAddress(IP_ADDRESS, SUBNET_ADDRESS, BROADCAST_ADDRESS);
        toAddr = new InterfaceIpAddress(fromAddr);
        Assert.assertThat((Object)toAddr.ipAddress(), (Matcher)Matchers.is((Object)fromAddr.ipAddress()));
        Assert.assertThat((Object)toAddr.subnetAddress(), (Matcher)Matchers.is((Object)fromAddr.subnetAddress()));
        Assert.assertThat((Object)toAddr.broadcastAddress(), (Matcher)Matchers.is((Object)fromAddr.broadcastAddress()));
        Assert.assertThat((Object)toAddr.peerAddress(), (Matcher)Matchers.is((Object)fromAddr.peerAddress()));
        fromAddr = new InterfaceIpAddress(IP_ADDRESS, SUBNET_ADDRESS, null, PEER_ADDRESS);
        toAddr = new InterfaceIpAddress(fromAddr);
        Assert.assertThat((Object)toAddr.ipAddress(), (Matcher)Matchers.is((Object)fromAddr.ipAddress()));
        Assert.assertThat((Object)toAddr.subnetAddress(), (Matcher)Matchers.is((Object)fromAddr.subnetAddress()));
        Assert.assertThat((Object)toAddr.broadcastAddress(), (Matcher)Matchers.is((Object)fromAddr.broadcastAddress()));
        Assert.assertThat((Object)toAddr.peerAddress(), (Matcher)Matchers.is((Object)fromAddr.peerAddress()));
    }

    @Test(expected=NullPointerException.class)
    public void testInvalidConstructorNullObject() {
        InterfaceIpAddress fromAddr = null;
        InterfaceIpAddress toAddr = new InterfaceIpAddress(fromAddr);
    }

    @Test
    public void testConstructorForDefaultBroadcastAddress() {
        InterfaceIpAddress addr = new InterfaceIpAddress(IP_ADDRESS, SUBNET_ADDRESS);
        Assert.assertThat((Object)addr.ipAddress(), (Matcher)Matchers.is((Object)IP_ADDRESS));
        Assert.assertThat((Object)addr.subnetAddress(), (Matcher)Matchers.is((Object)SUBNET_ADDRESS));
        Assert.assertThat((Object)addr.broadcastAddress(), (Matcher)Matchers.is((Object)DEF_BROADCAST_ADDRESS));
        Assert.assertThat((Object)addr.peerAddress(), (Matcher)Matchers.nullValue());
        IpPrefix subnetAddr = IpPrefix.valueOf((String)"10.2.3.0/24");
        InterfaceIpAddress addr1 = new InterfaceIpAddress(IP_ADDRESS2, subnetAddr);
        Assert.assertThat((Object)addr1.broadcastAddress().toString(), (Matcher)Matchers.is((Object)"10.2.3.255"));
        IpAddress ipAddress = IpAddress.valueOf((String)"2001::4");
        InterfaceIpAddress addr2 = new InterfaceIpAddress(ipAddress, V6_SUBNET_ADDRESS);
        Assert.assertThat((Object)addr2.broadcastAddress(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testConstructorForNonDefaultBroadcastAddress() {
        InterfaceIpAddress addr = new InterfaceIpAddress(IP_ADDRESS, SUBNET_ADDRESS, BROADCAST_ADDRESS);
        Assert.assertThat((Object)addr.ipAddress(), (Matcher)Matchers.is((Object)IP_ADDRESS));
        Assert.assertThat((Object)addr.subnetAddress(), (Matcher)Matchers.is((Object)SUBNET_ADDRESS));
        Assert.assertThat((Object)addr.broadcastAddress(), (Matcher)Matchers.is((Object)BROADCAST_ADDRESS));
        Assert.assertThat((Object)addr.peerAddress(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testConstructorForPointToPointAddress() {
        InterfaceIpAddress addr = new InterfaceIpAddress(IP_ADDRESS, SUBNET_ADDRESS, null, PEER_ADDRESS);
        Assert.assertThat((Object)addr.ipAddress(), (Matcher)Matchers.is((Object)IP_ADDRESS));
        Assert.assertThat((Object)addr.subnetAddress(), (Matcher)Matchers.is((Object)SUBNET_ADDRESS));
        Assert.assertThat((Object)addr.broadcastAddress(), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)addr.peerAddress(), (Matcher)Matchers.is((Object)PEER_ADDRESS));
    }

    @Test
    public void testGetFields() {
        InterfaceIpAddress addr = new InterfaceIpAddress(IP_ADDRESS, SUBNET_ADDRESS);
        Assert.assertThat((Object)addr.ipAddress().toString(), (Matcher)Matchers.is((Object)"1.2.3.4"));
        Assert.assertThat((Object)addr.subnetAddress().toString(), (Matcher)Matchers.is((Object)"1.2.0.0/16"));
        Assert.assertThat((Object)addr.broadcastAddress(), (Matcher)Matchers.is((Object)DEF_BROADCAST_ADDRESS));
        Assert.assertThat((Object)addr.peerAddress(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        addr = new InterfaceIpAddress(IP_ADDRESS, SUBNET_ADDRESS, BROADCAST_ADDRESS);
        Assert.assertThat((Object)addr.ipAddress().toString(), (Matcher)Matchers.is((Object)"1.2.3.4"));
        Assert.assertThat((Object)addr.subnetAddress().toString(), (Matcher)Matchers.is((Object)"1.2.0.0/16"));
        Assert.assertThat((Object)addr.broadcastAddress().toString(), (Matcher)Matchers.is((Object)"1.2.0.255"));
        Assert.assertThat((Object)addr.peerAddress(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        addr = new InterfaceIpAddress(IP_ADDRESS, SUBNET_ADDRESS, null, PEER_ADDRESS);
        Assert.assertThat((Object)addr.ipAddress().toString(), (Matcher)Matchers.is((Object)"1.2.3.4"));
        Assert.assertThat((Object)addr.subnetAddress().toString(), (Matcher)Matchers.is((Object)"1.2.0.0/16"));
        Assert.assertThat((Object)addr.broadcastAddress(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)addr.peerAddress().toString(), (Matcher)Matchers.is((Object)"5.6.7.8"));
    }

    @Test
    public void testEquality() {
        InterfaceIpAddress addr1 = new InterfaceIpAddress(IP_ADDRESS, SUBNET_ADDRESS);
        InterfaceIpAddress addr2 = new InterfaceIpAddress(IP_ADDRESS, SUBNET_ADDRESS);
        Assert.assertThat((Object)addr1, (Matcher)Matchers.is((Object)addr2));
        addr1 = new InterfaceIpAddress(IP_ADDRESS, SUBNET_ADDRESS, BROADCAST_ADDRESS);
        addr2 = new InterfaceIpAddress(IP_ADDRESS, SUBNET_ADDRESS, BROADCAST_ADDRESS);
        Assert.assertThat((Object)addr1, (Matcher)Matchers.is((Object)addr2));
        addr1 = new InterfaceIpAddress(IP_ADDRESS, SUBNET_ADDRESS, null, PEER_ADDRESS);
        addr2 = new InterfaceIpAddress(IP_ADDRESS, SUBNET_ADDRESS, null, PEER_ADDRESS);
        Assert.assertThat((Object)addr1, (Matcher)Matchers.is((Object)addr2));
    }

    @Test
    public void testNonEquality() {
        InterfaceIpAddress addr1 = new InterfaceIpAddress(IP_ADDRESS, SUBNET_ADDRESS);
        InterfaceIpAddress addr2 = new InterfaceIpAddress(IP_ADDRESS, SUBNET_ADDRESS, BROADCAST_ADDRESS);
        InterfaceIpAddress addr3 = new InterfaceIpAddress(IP_ADDRESS, SUBNET_ADDRESS, null, PEER_ADDRESS);
        Assert.assertThat((Object)addr1, (Matcher)Matchers.is((Matcher)Matchers.not((Object)addr2)));
        Assert.assertThat((Object)addr1, (Matcher)Matchers.is((Matcher)Matchers.not((Object)addr3)));
        Assert.assertThat((Object)addr2, (Matcher)Matchers.is((Matcher)Matchers.not((Object)addr3)));
        InterfaceIpAddress addr4 = new InterfaceIpAddress(IP_ADDRESS2, SUBNET_ADDRESS);
        Assert.assertThat((Object)addr1, (Matcher)Matchers.is((Matcher)Matchers.not((Object)addr4)));
        addr4 = new InterfaceIpAddress(IP_ADDRESS, SUBNET_ADDRESS2);
        Assert.assertThat((Object)addr1, (Matcher)Matchers.is((Matcher)Matchers.not((Object)addr4)));
        addr4 = new InterfaceIpAddress(IP_ADDRESS2, SUBNET_ADDRESS, BROADCAST_ADDRESS);
        Assert.assertThat((Object)addr2, (Matcher)Matchers.is((Matcher)Matchers.not((Object)addr4)));
        addr4 = new InterfaceIpAddress(IP_ADDRESS, SUBNET_ADDRESS2, BROADCAST_ADDRESS);
        Assert.assertThat((Object)addr2, (Matcher)Matchers.is((Matcher)Matchers.not((Object)addr4)));
        addr4 = new InterfaceIpAddress(IP_ADDRESS, SUBNET_ADDRESS, BROADCAST_ADDRESS2);
        Assert.assertThat((Object)addr2, (Matcher)Matchers.is((Matcher)Matchers.not((Object)addr4)));
        addr4 = new InterfaceIpAddress(IP_ADDRESS2, SUBNET_ADDRESS, null, PEER_ADDRESS);
        Assert.assertThat((Object)addr3, (Matcher)Matchers.is((Matcher)Matchers.not((Object)addr4)));
        addr4 = new InterfaceIpAddress(IP_ADDRESS, SUBNET_ADDRESS2, null, PEER_ADDRESS);
        Assert.assertThat((Object)addr3, (Matcher)Matchers.is((Matcher)Matchers.not((Object)addr4)));
        addr4 = new InterfaceIpAddress(IP_ADDRESS, SUBNET_ADDRESS, null, PEER_ADDRESS2);
        Assert.assertThat((Object)addr3, (Matcher)Matchers.is((Matcher)Matchers.not((Object)addr4)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIllegalConstructorArgument() {
        InterfaceIpAddress toAddr = new InterfaceIpAddress(IP_ADDRESS, V6_SUBNET_ADDRESS);
    }
}

