/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import java.util.concurrent.atomic.AtomicLong;
import org.onosproject.core.IdGenerator;
import org.onosproject.net.intent.Intent;

public final class MockIdGenerator
implements IdGenerator {
    public static final MockIdGenerator INSTANCE = new MockIdGenerator();
    private static boolean generatorIsBound = false;
    private AtomicLong nextId = new AtomicLong(0L);

    private MockIdGenerator() {
    }

    public static synchronized void cleanBind() {
        MockIdGenerator.INSTANCE.nextId = new AtomicLong(0L);
        if (!generatorIsBound) {
            generatorIsBound = true;
            Intent.unbindIdGenerator((IdGenerator)INSTANCE);
            Intent.bindIdGenerator((IdGenerator)INSTANCE);
        }
    }

    public static synchronized void unbind() {
        if (generatorIsBound) {
            generatorIsBound = false;
            Intent.unbindIdGenerator((IdGenerator)INSTANCE);
        }
    }

    public long getNewId() {
        return this.nextId.getAndIncrement();
    }
}

