/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.collect.Lists;
import com.google.common.testing.EqualsTester;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onlab.util.ImmutableByteSequence;
import org.onosproject.net.pi.model.PiActionId;
import org.onosproject.net.pi.model.PiActionParamId;
import org.onosproject.net.pi.runtime.PiAction;
import org.onosproject.net.pi.runtime.PiActionParam;
import org.onosproject.net.pi.runtime.PiActionProfileGroup;
import org.onosproject.net.pi.runtime.PiActionProfileGroupId;
import org.onosproject.net.pi.runtime.PiActionProfileMember;
import org.onosproject.net.pi.runtime.PiActionProfileMemberId;
import org.onosproject.net.pi.runtime.PiConstantsTest;

public class PiActionProfileGroupTest {
    private final PiActionProfileMemberId piActionProfileMemberId = PiActionProfileMemberId.of((int)10);
    private final PiAction piAction = PiAction.builder().withId(PiActionId.of((String)"mod_nw_dst")).withParameter(new PiActionParam(PiActionParamId.of((String)"dstAddr"), ImmutableByteSequence.copyFrom((int)0xA010101))).build();
    private final PiActionProfileMember piActionProfileMember = PiActionProfileMember.builder().forActionProfile(PiConstantsTest.ACTION_PROF_ID).withId(this.piActionProfileMemberId).withAction(this.piAction).withWeight(10).build();
    private PiActionProfileGroupId piActionGroupId = PiActionProfileGroupId.of((int)10);
    private PiActionProfileGroup piActionGroup1 = PiActionProfileGroup.builder().addMember(this.piActionProfileMember).withId(this.piActionGroupId).withActionProfileId(PiConstantsTest.ACTION_PROF_ID).build();
    private PiActionProfileGroup sameAsPiActionProfileGroup1 = PiActionProfileGroup.builder().addMember(this.piActionProfileMember).withId(this.piActionGroupId).withActionProfileId(PiConstantsTest.ACTION_PROF_ID).build();
    private PiActionProfileGroupId piActionGroupId2 = PiActionProfileGroupId.of((int)20);
    private PiActionProfileGroup piActionGroup2 = PiActionProfileGroup.builder().addMember(this.piActionProfileMember).withId(this.piActionGroupId2).withActionProfileId(PiConstantsTest.ACTION_PROF_ID).build();

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(PiActionProfileGroup.class);
    }

    @Test
    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.piActionGroup1, this.sameAsPiActionProfileGroup1}).addEqualityGroup(new Object[]{this.piActionGroup2}).testEquals();
    }

    @Test
    public void testMethods() {
        ArrayList piActionProfileMembers = Lists.newArrayList();
        piActionProfileMembers.add(this.piActionProfileMember);
        MatcherAssert.assertThat((Object)this.piActionGroup1, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.piActionGroup1.id(), (Matcher)Matchers.is((Object)this.piActionGroupId));
        MatcherAssert.assertThat((String)"Incorrect members value", (boolean)CollectionUtils.isEqualCollection((Collection)this.piActionGroup1.members(), (Collection)piActionProfileMembers));
    }
}

