/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.testing.EqualsTester;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onlab.util.ImmutableByteSequence;
import org.onosproject.net.pi.model.PiMatchFieldId;
import org.onosproject.net.pi.model.PiMatchType;
import org.onosproject.net.pi.runtime.PiTernaryFieldMatch;

public class PiTernaryFieldMatchTest {
    private final ImmutableByteSequence value1 = ImmutableByteSequence.copyFrom((int)0xA010101);
    private final ImmutableByteSequence mask1 = ImmutableByteSequence.copyFrom((int)0xFFFFFF);
    private final ImmutableByteSequence value2 = ImmutableByteSequence.copyFrom((int)167837954);
    private final ImmutableByteSequence mask2 = ImmutableByteSequence.copyFrom((int)65535);
    private final PiMatchFieldId piMatchField = PiMatchFieldId.of((String)"ipv4_t.dstAddr");
    private PiTernaryFieldMatch piTernaryFieldMatch1 = new PiTernaryFieldMatch(this.piMatchField, this.value1, this.mask1);
    private PiTernaryFieldMatch sameAsPiTernaryFieldMatch1 = new PiTernaryFieldMatch(this.piMatchField, this.value1, this.mask1);
    private PiTernaryFieldMatch piTernaryFieldMatch2 = new PiTernaryFieldMatch(this.piMatchField, this.value2, this.mask2);

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(PiTernaryFieldMatch.class);
    }

    @Test
    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.piTernaryFieldMatch1, this.sameAsPiTernaryFieldMatch1}).addEqualityGroup(new Object[]{this.piTernaryFieldMatch2}).testEquals();
    }

    @Test
    public void testConstruction() {
        ImmutableByteSequence value = ImmutableByteSequence.copyFrom((int)0xA01010A);
        ImmutableByteSequence mask = ImmutableByteSequence.copyFrom((int)0xFFFFFF);
        PiMatchFieldId piMatchField = PiMatchFieldId.of((String)"ipv4_t.dstAddr");
        PiTernaryFieldMatch piTernaryFieldMatch = new PiTernaryFieldMatch(piMatchField, value, mask);
        MatcherAssert.assertThat((Object)piTernaryFieldMatch, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)piTernaryFieldMatch.value(), (Matcher)Matchers.is((Object)value));
        MatcherAssert.assertThat((Object)piTernaryFieldMatch.mask(), (Matcher)Matchers.is((Object)mask));
        MatcherAssert.assertThat((Object)piTernaryFieldMatch.type(), (Matcher)Matchers.is((Object)PiMatchType.TERNARY));
    }
}

