/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.onosproject.net.pi.model.PiActionProfileId;
import org.onosproject.net.pi.runtime.PiAction;
import org.onosproject.net.pi.runtime.PiActionProfileMemberId;
import org.onosproject.net.pi.runtime.PiEntity;
import org.onosproject.net.pi.runtime.PiEntityType;

@Beta
public final class PiActionProfileMember
implements PiEntity {
    private final PiActionProfileId actionProfileId;
    private final PiActionProfileMemberId memberId;
    private final PiAction action;
    private final int weight;

    private PiActionProfileMember(PiActionProfileId actionProfileId, PiActionProfileMemberId memberId, PiAction action, int weight) {
        this.actionProfileId = actionProfileId;
        this.memberId = memberId;
        this.action = action;
        this.weight = weight;
    }

    public PiActionProfileMemberId id() {
        return this.memberId;
    }

    public PiActionProfileId actionProfile() {
        return this.actionProfileId;
    }

    public PiAction action() {
        return this.action;
    }

    public int weight() {
        return this.weight;
    }

    @Override
    public PiEntityType piEntityType() {
        return PiEntityType.ACTION_PROFILE_MEMBER;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PiActionProfileMember)) {
            return false;
        }
        PiActionProfileMember that = (PiActionProfileMember)o;
        return this.weight == that.weight && Objects.equal((Object)((Object)this.actionProfileId), (Object)((Object)that.actionProfileId)) && Objects.equal((Object)this.memberId, (Object)that.memberId) && Objects.equal((Object)this.action, (Object)that.action);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.actionProfileId, this.memberId, this.action, this.weight});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("actionProfile", (Object)this.actionProfileId).add("id", (Object)this.memberId).add("action", (Object)this.action).add("weight", this.weight).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private PiActionProfileId actionProfileId;
        private PiActionProfileMemberId id;
        private PiAction action;
        private int weight;

        private Builder() {
        }

        public Builder forActionProfile(PiActionProfileId actionProfileId) {
            this.actionProfileId = actionProfileId;
            return this;
        }

        public Builder withId(PiActionProfileMemberId id) {
            this.id = id;
            return this;
        }

        public Builder withAction(PiAction action) {
            this.action = action;
            return this;
        }

        public Builder withWeight(int weight) {
            this.weight = weight;
            return this;
        }

        public PiActionProfileMember build() {
            Preconditions.checkNotNull((Object)((Object)this.actionProfileId));
            Preconditions.checkNotNull((Object)this.id);
            Preconditions.checkNotNull((Object)this.action);
            return new PiActionProfileMember(this.actionProfileId, this.id, this.action, this.weight);
        }
    }
}

