/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.onosproject.net.DeviceId;
import org.onosproject.net.pi.model.PiActionProfileId;
import org.onosproject.net.pi.runtime.PiActionProfileMember;
import org.onosproject.net.pi.runtime.PiActionProfileMemberId;
import org.onosproject.net.pi.runtime.PiEntityType;
import org.onosproject.net.pi.runtime.PiHandle;

public final class PiActionProfileMemberHandle
extends PiHandle<PiActionProfileMember> {
    private final PiActionProfileMemberId memberId;
    private final PiActionProfileId actionProfileId;

    private PiActionProfileMemberHandle(DeviceId deviceId, PiActionProfileId actionProfileId, PiActionProfileMemberId memberId) {
        super(deviceId);
        this.actionProfileId = actionProfileId;
        this.memberId = memberId;
    }

    public static PiActionProfileMemberHandle of(DeviceId deviceId, PiActionProfileId actionProfileId, PiActionProfileMemberId memberId) {
        return new PiActionProfileMemberHandle(deviceId, actionProfileId, memberId);
    }

    public static PiActionProfileMemberHandle of(DeviceId deviceId, PiActionProfileMember member) {
        Preconditions.checkNotNull((Object)member);
        return new PiActionProfileMemberHandle(deviceId, member.actionProfile(), member.id());
    }

    public PiActionProfileMemberId memberId() {
        return this.memberId;
    }

    public PiActionProfileId actionProfileId() {
        return this.actionProfileId;
    }

    @Override
    public PiEntityType entityType() {
        return PiEntityType.ACTION_PROFILE_MEMBER;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.deviceId(), this.actionProfileId, this.memberId});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PiActionProfileMemberHandle other = (PiActionProfileMemberHandle)obj;
        return Objects.equal((Object)this.deviceId(), (Object)other.deviceId()) && Objects.equal((Object)((Object)this.actionProfileId), (Object)((Object)other.actionProfileId)) && Objects.equal((Object)this.memberId, (Object)other.memberId);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("deviceId", (Object)this.deviceId()).add("actionProfileId", (Object)this.actionProfileId).add("memberId", (Object)this.memberId).toString();
    }
}

