/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cluster;

import com.google.common.collect.Lists;
import com.google.common.testing.EqualsTester;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.onosproject.cluster.NodeId;
import org.onosproject.cluster.RoleInfo;

public class RoleInfoTest {
    private static final NodeId N1 = new NodeId("n1");
    private static final NodeId N2 = new NodeId("n2");
    private static final NodeId N3 = new NodeId("n3");
    private static final NodeId N4 = new NodeId("n4");
    private static final List<NodeId> BKUP1 = Lists.newArrayList((Object[])new NodeId[]{N2, N3});
    private static final List<NodeId> BKUP2 = Lists.newArrayList((Object[])new NodeId[]{N3, N4});
    private static final RoleInfo RI1 = new RoleInfo(N1, BKUP1);
    private static final RoleInfo RI2 = new RoleInfo(N1, BKUP2);
    private static final RoleInfo RI3 = new RoleInfo(N2, BKUP1);
    private static final RoleInfo RI4 = new RoleInfo(null, BKUP2);

    @Test
    public void testEquality() {
        new EqualsTester().addEqualityGroup(new Object[]{RI1, new RoleInfo(new NodeId("n1"), (List)Lists.newArrayList((Object[])new NodeId[]{N2, N3}))}).addEqualityGroup(new Object[]{RI3}).testEquals();
    }

    @Test
    public void basics() {
        Assert.assertEquals((String)"wrong master", (Object)new NodeId("n1"), (Object)RI1.master());
        Assert.assertEquals((String)"wrong Backups", (Object)RI1.backups(), (Object)Lists.newArrayList((Object[])new NodeId[]{N2, N3}));
        Assert.assertEquals((String)"wrong empty master", (Object)RI4.master(), null);
        ArrayList bkup3 = Lists.newArrayList((Object[])new NodeId[]{N3, new NodeId("n4")});
        Assert.assertEquals((String)"equals() broken", (Object)new RoleInfo(N1, (List)bkup3), (Object)RI2);
    }
}

