/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cluster;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.onosproject.cluster.NodeId;

public class RoleInfo {
    private final Optional<NodeId> master;
    private final List<NodeId> backups;

    public RoleInfo(NodeId master, List<NodeId> backups) {
        this.master = Optional.ofNullable(master);
        this.backups = ImmutableList.copyOf(backups);
    }

    public RoleInfo() {
        this.master = Optional.empty();
        this.backups = ImmutableList.of();
    }

    public NodeId master() {
        return this.master.orElseGet(() -> null);
    }

    public List<NodeId> backups() {
        return this.backups;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RoleInfo)) {
            return false;
        }
        RoleInfo that = (RoleInfo)other;
        return Objects.equals(this.master, that.master) && Objects.equals(this.backups, that.backups);
    }

    public int hashCode() {
        return Objects.hash(this.master, this.backups);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("master", (Object)this.master.orElseGet(() -> null)).add("backups", this.backups).toString();
    }
}

