/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow.criteria;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onlab.packet.MacAddress;
import org.onosproject.net.flow.criteria.Criterion;

public final class ArpHaCriterion
implements Criterion {
    private final MacAddress mac;
    private final Criterion.Type type;

    ArpHaCriterion(MacAddress mac, Criterion.Type type) {
        Preconditions.checkNotNull((Object)mac, (Object)"mac cannot be null");
        Preconditions.checkNotNull((Object)((Object)type), (Object)"type cannot be null");
        this.mac = mac;
        this.type = type;
    }

    @Override
    public Criterion.Type type() {
        return this.type;
    }

    public MacAddress mac() {
        return this.mac;
    }

    public String toString() {
        return this.type().toString() + ":" + this.mac;
    }

    public int hashCode() {
        return Objects.hash(this.type().ordinal(), this.mac);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ArpHaCriterion) {
            ArpHaCriterion that = (ArpHaCriterion)obj;
            return Objects.equals(this.mac, that.mac) && Objects.equals((Object)this.type, (Object)that.type);
        }
        return false;
    }
}

