/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.onosproject.net.DeviceId;
import org.onosproject.net.pi.runtime.PiEntityType;
import org.onosproject.net.pi.runtime.PiHandle;
import org.onosproject.net.pi.runtime.PiMulticastGroupEntry;

@Beta
public final class PiMulticastGroupEntryHandle
extends PiHandle {
    private final int groupId;

    private PiMulticastGroupEntryHandle(DeviceId deviceId, int groupId) {
        super(deviceId);
        this.groupId = groupId;
    }

    public static PiMulticastGroupEntryHandle of(DeviceId deviceId, int groupId) {
        return new PiMulticastGroupEntryHandle(deviceId, groupId);
    }

    public static PiMulticastGroupEntryHandle of(DeviceId deviceId, PiMulticastGroupEntry entry) {
        Preconditions.checkNotNull((Object)entry);
        return new PiMulticastGroupEntryHandle(deviceId, entry.groupId());
    }

    public int groupId() {
        return this.groupId;
    }

    @Override
    public PiEntityType entityType() {
        return PiEntityType.PRE_MULTICAST_GROUP_ENTRY;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.deviceId(), this.groupId});
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PiMulticastGroupEntryHandle that = (PiMulticastGroupEntryHandle)o;
        return Objects.equal((Object)this.deviceId(), (Object)that.deviceId()) && Objects.equal((Object)this.groupId, (Object)that.groupId);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("deviceId", (Object)this.deviceId()).add("groupId", this.groupId).toString();
    }
}

