/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime.data;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.StringJoiner;
import org.onosproject.net.pi.model.PiData;
import org.onosproject.net.pi.runtime.data.PiHeader;

@Beta
public final class PiHeaderStack
implements PiData {
    private final ImmutableList<PiHeader> headers;

    private PiHeaderStack(List<PiHeader> headers) {
        this.headers = ImmutableList.copyOf(headers);
    }

    public static PiHeaderStack of(List<PiHeader> headers) {
        return new PiHeaderStack(headers);
    }

    public List<PiHeader> headers() {
        return this.headers;
    }

    @Override
    public PiData.Type type() {
        return PiData.Type.HEADERSTACK;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PiHeaderStack stack = (PiHeaderStack)o;
        return Objects.equal(this.headers, stack.headers);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.headers});
    }

    public String toString() {
        StringJoiner stringParams = new StringJoiner(", ", "(", ")");
        this.headers().forEach(p -> stringParams.add(p.toString()));
        return stringParams.toString();
    }
}

