/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime.data;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.StringJoiner;
import org.onosproject.net.pi.model.PiData;

@Beta
public final class PiStruct
implements PiData {
    private final ImmutableList<PiData> struct;

    private PiStruct(List<PiData> struct) {
        this.struct = ImmutableList.copyOf(struct);
    }

    public static PiStruct of(List<PiData> struct) {
        return new PiStruct(struct);
    }

    public List<PiData> struct() {
        return this.struct;
    }

    @Override
    public PiData.Type type() {
        return PiData.Type.STRUCT;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PiStruct st = (PiStruct)o;
        return Objects.equal(this.struct, st.struct);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.struct});
    }

    public String toString() {
        StringJoiner stringParams = new StringJoiner(", ", "(", ")");
        this.struct().forEach(p -> stringParams.add(p.toString()));
        return stringParams.toString();
    }
}

