/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives;

import java.util.concurrent.CompletableFuture;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.store.primitives.AsyncAtomicCounterMapAdapter;
import org.onosproject.store.primitives.DefaultAtomicCounterMap;
import org.onosproject.store.primitives.TestingCompletableFutures;
import org.onosproject.store.service.ConsistentMapException;

public class DefaultAtomicCounterMapTest {
    private static final String KEY1 = "myKey1";
    private static final long VALUE1 = 444L;
    private static final long DELTA1 = 555L;
    private DefaultAtomicCounterMap<String> atomicCounterMap;

    private DefaultAtomicCounterMap<String> createMap() {
        AsyncAtomicCounterMapAdapter asyncMap = new AsyncAtomicCounterMapAdapter();
        DefaultAtomicCounterMap map = new DefaultAtomicCounterMap(asyncMap, 1000L);
        MatcherAssert.assertThat((Object)map, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)map.isEmpty(), (Matcher)Matchers.is((Object)true));
        return map;
    }

    @Before
    public void setUpMap() {
        this.atomicCounterMap = this.createMap();
    }

    @Test
    public void testConstruction() {
        MatcherAssert.assertThat((Object)this.atomicCounterMap.size(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testPutAndGet() {
        this.atomicCounterMap.put((Object)KEY1, 444L);
        long value = this.atomicCounterMap.get((Object)KEY1);
        MatcherAssert.assertThat((Object)value, (Matcher)Matchers.is((Object)444L));
    }

    @Test
    public void testGetAndIncrement() {
        this.atomicCounterMap.put((Object)KEY1, 444L);
        Long beforeIncrement = this.atomicCounterMap.getAndIncrement((Object)KEY1);
        MatcherAssert.assertThat((Object)beforeIncrement, (Matcher)Matchers.is((Object)444L));
        Long afterIncrement = this.atomicCounterMap.get((Object)KEY1);
        MatcherAssert.assertThat((Object)afterIncrement, (Matcher)Matchers.is((Object)445L));
    }

    @Test
    public void testIncrementAndGet() {
        this.atomicCounterMap.put((Object)KEY1, 444L);
        Long afterIncrement = this.atomicCounterMap.incrementAndGet((Object)KEY1);
        MatcherAssert.assertThat((Object)afterIncrement, (Matcher)Matchers.is((Object)445L));
    }

    @Test
    public void testGetAndDecrement() {
        this.atomicCounterMap.put((Object)KEY1, 444L);
        Long beforeDecrement = this.atomicCounterMap.getAndDecrement((Object)KEY1);
        MatcherAssert.assertThat((Object)beforeDecrement, (Matcher)Matchers.is((Object)444L));
        Long afterDecrement = this.atomicCounterMap.get((Object)KEY1);
        MatcherAssert.assertThat((Object)afterDecrement, (Matcher)Matchers.is((Object)443L));
    }

    @Test
    public void testDecrementAndGet() {
        this.atomicCounterMap.put((Object)KEY1, 444L);
        Long afterIncrement = this.atomicCounterMap.decrementAndGet((Object)KEY1);
        MatcherAssert.assertThat((Object)afterIncrement, (Matcher)Matchers.is((Object)443L));
    }

    @Test
    public void testGetAndAdd() {
        this.atomicCounterMap.put((Object)KEY1, 444L);
        Long beforeIncrement = this.atomicCounterMap.getAndAdd((Object)KEY1, 555L);
        MatcherAssert.assertThat((Object)beforeIncrement, (Matcher)Matchers.is((Object)444L));
        Long afterIncrement = this.atomicCounterMap.get((Object)KEY1);
        MatcherAssert.assertThat((Object)afterIncrement, (Matcher)Matchers.is((Object)999L));
    }

    @Test
    public void testAddAndGet() {
        this.atomicCounterMap.put((Object)KEY1, 444L);
        Long afterIncrement = this.atomicCounterMap.addAndGet((Object)KEY1, 555L);
        MatcherAssert.assertThat((Object)afterIncrement, (Matcher)Matchers.is((Object)999L));
    }

    @Test
    public void testPutIfAbsent() {
        this.atomicCounterMap.putIfAbsent((Object)KEY1, 444L);
        Long afterIncrement = this.atomicCounterMap.addAndGet((Object)KEY1, 555L);
        MatcherAssert.assertThat((Object)afterIncrement, (Matcher)Matchers.is((Object)999L));
    }

    @Test
    public void testClear() {
        this.atomicCounterMap.putIfAbsent((Object)KEY1, 444L);
        MatcherAssert.assertThat((Object)this.atomicCounterMap.size(), (Matcher)Matchers.is((Object)1));
        this.atomicCounterMap.clear();
        MatcherAssert.assertThat((Object)this.atomicCounterMap.size(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testReplace() {
        this.atomicCounterMap.putIfAbsent((Object)KEY1, 444L);
        boolean replaced = this.atomicCounterMap.replace((Object)KEY1, 444L, 888L);
        MatcherAssert.assertThat((Object)replaced, (Matcher)Matchers.is((Object)true));
        Long afterReplace = this.atomicCounterMap.get((Object)KEY1);
        MatcherAssert.assertThat((Object)afterReplace, (Matcher)Matchers.is((Object)888L));
        boolean notReplaced = this.atomicCounterMap.replace((Object)KEY1, 444L, 888L);
        MatcherAssert.assertThat((Object)notReplaced, (Matcher)Matchers.is((Object)false));
        Long afterNotReplaced = this.atomicCounterMap.get((Object)KEY1);
        MatcherAssert.assertThat((Object)afterNotReplaced, (Matcher)Matchers.is((Object)888L));
    }

    @Test
    public void testRemove() {
        this.atomicCounterMap.putIfAbsent((Object)KEY1, 444L);
        MatcherAssert.assertThat((Object)this.atomicCounterMap.size(), (Matcher)Matchers.is((Object)1));
        this.atomicCounterMap.remove((Object)KEY1);
        MatcherAssert.assertThat((Object)this.atomicCounterMap.size(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testRemoveVale() {
        this.atomicCounterMap.putIfAbsent((Object)KEY1, 444L);
        MatcherAssert.assertThat((Object)this.atomicCounterMap.size(), (Matcher)Matchers.is((Object)1));
        this.atomicCounterMap.remove((Object)KEY1, 888L);
        MatcherAssert.assertThat((Object)this.atomicCounterMap.size(), (Matcher)Matchers.is((Object)1));
        this.atomicCounterMap.remove((Object)KEY1, 444L);
        MatcherAssert.assertThat((Object)this.atomicCounterMap.size(), (Matcher)Matchers.is((Object)0));
    }

    @Test(expected=ConsistentMapException.Timeout.class)
    public void testTimeout() {
        AtomicCounterMapWithErrors atomicCounterMap = new AtomicCounterMapWithErrors();
        atomicCounterMap.setErrorState(TestingCompletableFutures.ErrorState.TIMEOUT_EXCEPTION);
        DefaultAtomicCounterMap map = new DefaultAtomicCounterMap(atomicCounterMap, 1000L);
        map.get((Object)KEY1);
    }

    @Test(expected=ConsistentMapException.Interrupted.class)
    public void testInterrupted() {
        AtomicCounterMapWithErrors atomicCounterMap = new AtomicCounterMapWithErrors();
        atomicCounterMap.setErrorState(TestingCompletableFutures.ErrorState.INTERRUPTED_EXCEPTION);
        DefaultAtomicCounterMap map = new DefaultAtomicCounterMap(atomicCounterMap, 1000L);
        map.get((Object)KEY1);
    }

    @Test(expected=ConsistentMapException.class)
    public void testExecutionError() {
        AtomicCounterMapWithErrors atomicCounterMap = new AtomicCounterMapWithErrors();
        atomicCounterMap.setErrorState(TestingCompletableFutures.ErrorState.EXECUTION_EXCEPTION);
        DefaultAtomicCounterMap map = new DefaultAtomicCounterMap(atomicCounterMap, 1000L);
        map.get((Object)KEY1);
    }

    class AtomicCounterMapWithErrors<K>
    extends AsyncAtomicCounterMapAdapter<K> {
        TestingCompletableFutures.ErrorState errorState = TestingCompletableFutures.ErrorState.NONE;

        void setErrorState(TestingCompletableFutures.ErrorState errorState) {
            this.errorState = errorState;
        }

        AtomicCounterMapWithErrors() {
        }

        @Override
        public CompletableFuture<Long> get(K key) {
            return TestingCompletableFutures.createFuture(this.errorState);
        }
    }
}

