/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.alarm;

import org.onosproject.net.DeviceId;

import java.io.InputStream;
import java.util.Collection;

/**
 * Abstraction of ability to translate device messages into alarms.
 */
public interface AlarmTranslator {

    /**
     * Translates message from device into an alarm with appropriate
     * information.
     *
     * @param deviceId device
     * @param message message from device to translate to alarm
     * @return Alarm with information determined by given message
     */
    Collection<Alarm> translateToAlarm(DeviceId deviceId, InputStream message);
}
