/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Collections;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.CltSignalType;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.ResourceGroup;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.Key;

@Beta
public final class OpticalOduIntent
extends Intent {
    private final ConnectPoint src;
    private final ConnectPoint dst;
    private final CltSignalType signalType;
    private final boolean isBidirectional;

    protected OpticalOduIntent(ApplicationId appId, Key key, ConnectPoint src, ConnectPoint dst, CltSignalType signalType, boolean isBidirectional, int priority, ResourceGroup resourceGroup) {
        super(appId, key, Collections.emptyList(), priority, resourceGroup);
        this.src = (ConnectPoint)Preconditions.checkNotNull((Object)src);
        this.dst = (ConnectPoint)Preconditions.checkNotNull((Object)dst);
        this.signalType = (CltSignalType)((Object)Preconditions.checkNotNull((Object)((Object)signalType)));
        this.isBidirectional = isBidirectional;
    }

    public static Builder builder() {
        return new Builder();
    }

    protected OpticalOduIntent() {
        this.src = null;
        this.dst = null;
        this.signalType = null;
        this.isBidirectional = false;
    }

    public ConnectPoint getSrc() {
        return this.src;
    }

    public ConnectPoint getDst() {
        return this.dst;
    }

    public CltSignalType getSignalType() {
        return this.signalType;
    }

    public boolean isBidirectional() {
        return this.isBidirectional;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id()).add("key", (Object)this.key()).add("appId", (Object)this.appId()).add("priority", this.priority()).add("resources", this.resources()).add("src", (Object)this.src).add("dst", (Object)this.dst).add("signalType", (Object)this.signalType).add("isBidirectional", this.isBidirectional).add("resourceGroup", (Object)this.resourceGroup()).toString();
    }

    public static class Builder
    extends Intent.Builder {
        private ConnectPoint src;
        private ConnectPoint dst;
        private CltSignalType signalType;
        private boolean isBidirectional;

        @Override
        public Builder appId(ApplicationId appId) {
            return (Builder)super.appId(appId);
        }

        @Override
        public Builder key(Key key) {
            return (Builder)super.key(key);
        }

        @Override
        public Builder priority(int priority) {
            return (Builder)super.priority(priority);
        }

        @Override
        public Builder resourceGroup(ResourceGroup resourceGroup) {
            return (Builder)super.resourceGroup(resourceGroup);
        }

        public Builder src(ConnectPoint src) {
            this.src = src;
            return this;
        }

        public Builder dst(ConnectPoint dst) {
            this.dst = dst;
            return this;
        }

        public Builder signalType(CltSignalType signalType) {
            this.signalType = signalType;
            return this;
        }

        public Builder bidirectional(boolean isBidirectional) {
            this.isBidirectional = isBidirectional;
            return this;
        }

        public OpticalOduIntent build() {
            return new OpticalOduIntent(this.appId, this.key, this.src, this.dst, this.signalType, this.isBidirectional, this.priority, this.resourceGroup);
        }
    }
}

