/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.onosproject.net.driver.Behaviour;
import org.onosproject.net.pi.model.PiPipeconf;
import org.onosproject.net.pi.model.PiPipeconfId;
import org.onosproject.net.pi.model.PiPipelineModel;

public final class DefaultPiPipeconf
implements PiPipeconf {
    private final PiPipeconfId id;
    private final PiPipelineModel pipelineModel;
    private final long fingerprint;
    private final Map<Class<? extends Behaviour>, Class<? extends Behaviour>> behaviours;
    private final Map<PiPipeconf.ExtensionType, URL> extensions;

    private DefaultPiPipeconf(PiPipeconfId id, PiPipelineModel pipelineModel, long fingerprint, Map<Class<? extends Behaviour>, Class<? extends Behaviour>> behaviours, Map<PiPipeconf.ExtensionType, URL> extensions) {
        this.id = id;
        this.pipelineModel = pipelineModel;
        this.fingerprint = fingerprint;
        this.behaviours = behaviours;
        this.extensions = extensions;
    }

    @Override
    public PiPipeconfId id() {
        return this.id;
    }

    @Override
    public PiPipelineModel pipelineModel() {
        return this.pipelineModel;
    }

    @Override
    public long fingerprint() {
        return this.fingerprint;
    }

    @Override
    public Collection<Class<? extends Behaviour>> behaviours() {
        return this.behaviours.keySet();
    }

    @Override
    public Optional<Class<? extends Behaviour>> implementation(Class<? extends Behaviour> behaviour) {
        return Optional.ofNullable(this.behaviours.get(behaviour));
    }

    @Override
    public boolean hasBehaviour(Class<? extends Behaviour> behaviourClass) {
        return this.behaviours.containsKey(behaviourClass);
    }

    @Override
    public Optional<InputStream> extension(PiPipeconf.ExtensionType type) {
        if (this.extensions.containsKey((Object)type)) {
            try {
                return Optional.of(this.extensions.get((Object)type).openStream());
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return Optional.empty();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private PiPipeconfId id;
        private PiPipelineModel pipelineModel;
        private ImmutableMap.Builder<Class<? extends Behaviour>, Class<? extends Behaviour>> behaviourMapBuilder = ImmutableMap.builder();
        private ImmutableMap.Builder<PiPipeconf.ExtensionType, URL> extensionMapBuilder = ImmutableMap.builder();

        public Builder withId(PiPipeconfId id) {
            this.id = id;
            return this;
        }

        public Builder withPipelineModel(PiPipelineModel model) {
            this.pipelineModel = model;
            return this;
        }

        public Builder addBehaviour(Class<? extends Behaviour> clazz, Class<? extends Behaviour> implementation) {
            Preconditions.checkNotNull(clazz);
            Preconditions.checkNotNull(implementation);
            this.behaviourMapBuilder.put(clazz, implementation);
            return this;
        }

        public Builder addExtension(PiPipeconf.ExtensionType type, URL url) {
            Preconditions.checkNotNull((Object)((Object)type));
            Preconditions.checkNotNull((Object)url);
            Preconditions.checkArgument((boolean)this.checkUrl(url), (Object)String.format("Extension url %s seems to be empty/non existent", url.toString()));
            this.extensionMapBuilder.put((Object)type, (Object)url);
            return this;
        }

        private boolean checkUrl(URL url) {
            try {
                int byteCount = url.openStream().available();
                return byteCount > 0;
            }
            catch (IOException e) {
                return false;
            }
        }

        public PiPipeconf build() {
            Preconditions.checkNotNull((Object)((Object)this.id));
            Preconditions.checkNotNull((Object)this.pipelineModel);
            ImmutableMap extensions = this.extensionMapBuilder.build();
            ImmutableMap behaviours = this.behaviourMapBuilder.build();
            return new DefaultPiPipeconf(this.id, this.pipelineModel, this.generateFingerprint(extensions.values()), (Map)behaviours, (Map)extensions);
        }

        private long generateFingerprint(Collection<URL> extensions) {
            ArrayList<Integer> hashes = new ArrayList<Integer>();
            for (URL extUrl : extensions) {
                try {
                    HashingInputStream hin = new HashingInputStream(Hashing.crc32(), extUrl.openStream());
                    while (hin.read() != -1) {
                    }
                    hashes.add(hin.hash().asInt());
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            int low = Arrays.hashCode(hashes.toArray());
            int high = this.pipelineModel.hashCode();
            return ByteBuffer.allocate(8).putInt(high).putInt(low).getLong(0);
        }
    }
}

