/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.alarm;

import java.io.IOException;
import java.io.InputStream;
import java.time.DateTimeException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XmlEventParser {
    public static final Logger log = LoggerFactory.getLogger(XmlEventParser.class);
    private static final String DISALLOW_DTD_FEATURE = "http://apache.org/xml/features/disallow-doctype-decl";
    private static final String DISALLOW_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    private static final String EVENTTIME_TAGNAME = "eventTime";

    private XmlEventParser() {
    }

    public static Document createDocFromMessage(InputStream message) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
        XmlEventParser.disableFeature(dbfactory, DISALLOW_DTD_FEATURE);
        XmlEventParser.disableFeature(dbfactory, DISALLOW_EXTERNAL_DTD);
        dbfactory.setXIncludeAware(false);
        dbfactory.setExpandEntityReferences(false);
        DocumentBuilder builder = dbfactory.newDocumentBuilder();
        return builder.parse(new InputSource(message));
    }

    private static void disableFeature(DocumentBuilderFactory dbfactory, String feature) {
        try {
            dbfactory.setFeature(feature, true);
        }
        catch (ParserConfigurationException e) {
            log.info("ParserConfigurationException was thrown. The feature '" + feature + "' is probably not supported by your XML processor.");
        }
    }

    public static long getEventTime(String dateTime) throws UnsupportedOperationException, IllegalArgumentException {
        try {
            OffsetDateTime date = OffsetDateTime.parse(dateTime, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
            return date.toInstant().toEpochMilli();
        }
        catch (DateTimeException e) {
            log.error("Cannot parse exception {} {}", (Object)dateTime, (Object)e);
            return System.currentTimeMillis();
        }
    }

    public static long getEventTime(Document doc) throws UnsupportedOperationException, IllegalArgumentException {
        String dateTime = XmlEventParser.getEventTimeNode(doc).getTextContent();
        return XmlEventParser.getEventTime(dateTime);
    }

    public static Node getDescriptionNode(Document doc) {
        return XmlEventParser.getEventTimeNode(doc).getNextSibling();
    }

    private static Node getEventTimeNode(Document doc) {
        return doc.getElementsByTagName(EVENTTIME_TAGNAME).item(0);
    }
}

